<?php
    $global_actions = new Personal_Dictionary_Reports_Actions($this->plugin_name);
    $selected_user_id = isset($_GET['user']) && $_GET['user'] != '' ? sanitize_text_field($_GET['user']) : '';
?>

<div id="user-vocabulary" class="ays-pd-reports-tab-content">
    <div class="wrap">
        <div class="ays-pd-heading-box">
            <div class="ays-pd-wordpress-user-manual-box">
                <a href="https://ays-pro.com/wordpress-personal-dictionary-user-manual" target="_blank"><?php echo __("View Documentation", $this->plugin_name); ?></a>
            </div>
        </div>
        <h1 class="wp-heading-inline">
            <?php
                echo __(esc_html(get_admin_page_title()),$this->plugin_name);
            ?>
        </h1>
        <?php 
            echo $global_actions->display_reports_page_top_navigation($this->plugin_name) 
        ?>
        <div class="ays-pd-user-vocabulary-main-container ays_pd_user_vocabulary_list_table">
            <div class="ays-pd-user-vocabulary-select-container">
                <?php 
                    $users = $global_actions->get_users_list(); 
                ?>
                <select name="ays_pd_users_vocabulary_users" id="ays_pd_users_select">
                    <option value="0"><?php echo __( "Select User", $this->plugin_name ); ?></option>
                    <?php foreach ($users as $user_id => $user_name) {
                        $selected = ($user_id == $selected_user_id) ? 'selected' : '';
                        echo "<option value = '" . $user_id . "' ".$selected.">" . stripslashes($user_name) . "</option >";
                    } ?>
                </select>
            </div>
            <?php
                if($selected_user_id == ''):
            ?>
            <div class="ays-pd-user-vocabulary-empty-users">
                <div class="ays-pd-user-vocabulary-empty-users-box" style="font-size: 17px;border-color:#f3ca03;">
                    <?php echo __("Select the user to see the list of words he/she added." , $this->plugin_name); ?>
                </div>
            </div>
            <?php else: ?>
            <hr>
            <div class="ays-pd-user-vocabulary-main-content">
                <div id="poststuff">
                    <div id="post-body" class="metabox-holder">
                        <div id="post-body-content">
                            <div class="meta-box-sortables ui-sortable">
                                <form method="post">
                                    <?php
                                        $this->user_vocabulary_obj->prepare_items();
                                        $search = __( "Search", $this->plugin_name );
                                        $this->user_vocabulary_obj->search_box($search, $this->plugin_name);
                                        $this->user_vocabulary_obj->display();
                                    ?>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php
                endif;
            ?>
        </div>
    </div>
</div>