<?php
    $global_actions = new Personal_Dictionary_Settings_Actions($this->plugin_name);        
    $global_actions->ays_pd_store_global_settings();
    $options = $global_actions->ays_pd_get_setting();
    $loader_iamge = "<span class='display_none'><img width='20' height='20' src=".PERSONAL_DICTIONARY_ADMIN_URL."/images/loaders/loading.gif></span>";

    // Defaults
    $learned_points = 10;
    $right_points = 1;
    $wrong_points = -0.25;
    $enable_full_screen_mode = false;
    $enable_full_screen_mode_mobile = false;
    $enable_add_words_from_front = 'off';
    $enable_add_image_from_front = 'off';
    $enable_add_audio_from_front = 'off';
    $enable_add_image_to_games = 'off';
    $enable_add_audio_to_games = 'off';
    $show_games = 'on';
    $show_game_find_the_word = 'on';
    $show_game_find_the_translation = 'on';
    $show_game_matching_words = 'on';
    $show_game_write_the_translation = 'on';
    $show_correct_answer = false;
    $show_correct_answer_mobile = false;
    $show_next_button = "on";
    $show_next_button = true;
    $show_next_button_mobile = true;
    $games_animation_effect = "none";
    $enable_games_animation_effect_mobile = 'on';
    $games_animation_effect_mobile = 'none';
    $bg_color = "#ffffff";
    $enable_bg_color_mobile = 'on';
    $bg_color_mobile = "#ffffff";
    $main_color = "#1a7efb";
    $enable_main_color_mobile = 'on';
    $main_color_mobile = "#1a7efb";
    $text_color = "#000";
    $enable_text_color_mobile = 'on';
    $text_color_mobile = "#000";
    $button_text_color = "#ffffff";
    $container_border_color = "#ccc";
    $enable_container_border_color_mobile = 'on';
    $container_border_color_mobile = "#ccc";
    $button_font_size = 14;
    $button_font_size_for_mobile = 14;
    $buttons_left_right_padding = 12;
    $buttons_top_bottom_padding = 7;
    $buttons_border_radius = 6;
    $container_border_radius = 6;
    $container_border_radius_mobile = 6;
    $enable_container_border_radius_mobile = 'on';
    $container_border_width = 0;
    $container_border_width_mobile = 1;
    $enable_container_border_width_mobile = 'on';
    $answer_border_width = 1;
    $answer_border_width_mobile = 1;
    $enable_answer_border_width_mobile = 'on';
    $answer_border_color = 'rgba(148,148,148,0.85)';
    $container_border_style = 'solid';
    $enable_container_border_style_mobile = 'on';
    $container_border_style_mobile = 'solid';
    $enable_container_box_shadow = true;
    $container_box_shadow_color = "rgba(21, 62, 113, 0.14)";
    $container_box_shadow_x_offset = 0;
    $container_box_shadow_y_offset = 4;
    $container_box_shadow_z_offset = 9;
    $enable_answer_box_shadow = false;
    $answer_box_shadow_color = 'rgba(21, 62, 113, 0.14)';
    $answer_box_shadow_x_offset = 0;
    $answer_box_shadow_y_offset = 4;
    $answer_box_shadow_z_offset = 9;
    $answer_border_style = 'solid';
    $question_font_size = 16;
    $question_font_size_for_mobile = 16;
    $answer_bg_color = "#ffffff";
    $answer_font_size = 15;
    $answer_font_size_for_mobile = 15;
    $custom_class = "";
    $custom_css = "";
    $pd_title = "Dictionary";
    $show_pd_title = "on";
    $show_pd_title_mobile = "on";
    $enable_title_text_shadow = "off";
    $title_text_shadow_color = "rgba(234,234,234,0)";
    $title_text_shadow_x_offset = 2;
    $title_text_shadow_y_offset = 2;
    $title_text_shadow_z_offset = 2;
    $pd_title_alignment = "left";
    $enable_pd_title_alignment_mobile = "on";
    $pd_title_alignment_mobile = "left";
    $pd_answer_view = "grid";
    $enable_pd_answer_view_mobile = "on";
    $pd_answer_view_mobile = "grid";
    $pd_description = "";
    $pd_wp_editor_height = 100;
    $show_pd_description = "on";
    $show_pd_description_mobile = "on";
    $description_font_size = 18;
    $description_font_size_for_mobile = 18;
    $title_font_size = 30;
    $title_font_size_for_mobile = 30;
    $pd_desc_alignment = "left";
    $enable_pd_desc_alignment_mobile = "on";
    $pd_desc_alignment_mobile = "left";
    $enable_description_text_shadow = "off";
    $ays_pd_enable_answer_border = "on";
    $description_text_shadow_color = "rgba(234,234,234,0)";
    $description_text_shadow_x_offset = 2;
    $description_text_shadow_y_offset = 2;
    $description_text_shadow_z_offset = 2;
    $menu_items = 'text-icon';
    $enable_menu_items_mobile = 'on';
    $menu_items_mobile = 'icon';
    $menu_position = 'left';
    $enable_menu_position_mobile = 'on';
    $menu_position_mobile = 'top';
    $menu_layout = 'grid';
    $enable_menu_layout_mobile = 'off';
    $menu_layout_mobile = 'grid';
    $change_group_name = 'Group';
    $change_word_name = 'Word';
    $change_translation_name = 'Translation';

    // Check options
    if(isset($options) && !empty($options)){
        $learned_points = isset($options['learned_points']) && $options['learned_points'] != '' ? esc_attr(floatval($options['learned_points'])) : 10;
        $right_points = isset($options['right_points']) && $options['right_points'] != '' ? esc_attr(floatval($options['right_points'])) : 1;
        $wrong_points        = isset($options['wrong_points']) && $options['wrong_points'] != '' ? esc_attr(floatval($options['wrong_points'])) : -0.25; 
        $enable_add_words_from_front = isset($options['enable_add_words_from_front']) && $options['enable_add_words_from_front'] == 'on' ? 'on' : 'off';
        $enable_add_image_from_front = isset($options['enable_add_image_from_front']) && $options['enable_add_image_from_front'] == 'on' ? 'on' : 'off';
        $enable_add_audio_from_front = isset($options['enable_add_audio_from_front']) && $options['enable_add_audio_from_front'] == 'on' ? 'on' : 'off';
        $enable_add_image_to_games = isset($options['enable_add_image_to_games']) && $options['enable_add_image_to_games'] == 'on' ? 'on' : 'off';
        $enable_add_audio_to_games = isset($options['enable_add_audio_to_games']) && $options['enable_add_audio_to_games'] == 'on' ? 'on' : 'off';
        $show_games = isset($options['show_games']) && $options['show_games'] == 'off' ? 'off' : 'on';
        $show_game_find_the_word = isset($options['show_game_find_the_word']) && $options['show_game_find_the_word'] == 'off' ? 'off' : 'on';
        $show_game_find_the_translation = isset($options['show_game_find_the_translation']) && $options['show_game_find_the_translation'] == 'off' ? 'off' : 'on';
        $show_game_matching_words = isset($options['show_game_matching_words']) && $options['show_game_matching_words'] == 'off' ? 'off' : 'on';
        $show_game_write_the_translation = isset($options['show_game_write_the_translation']) && $options['show_game_write_the_translation'] == 'off' ? 'off' : 'on';
        $options['show_correct_answer'] = isset($options['show_correct_answer']) && $options['show_correct_answer'] == 'on' ? 'on' : 'off';
        $show_correct_answer = (isset($options['show_correct_answer']) && $options['show_correct_answer'] == 'on') ?  true : false;        
        // Enable full screen mode
        $options['enable_full_screen_mode'] = isset($options['enable_full_screen_mode']) && $options['enable_full_screen_mode'] == 'on' ? 'on' : 'off';
        $enable_full_screen_mode = (isset($options['enable_full_screen_mode']) && $options['enable_full_screen_mode'] == 'on') ?  true : false;
        if ( isset($options['enable_full_screen_mode_mobile']) ) {
            $enable_full_screen_mode_mobile = $options['enable_full_screen_mode_mobile'] == 'on' ? 'on' : 'off';
        } else {
            $enable_full_screen_mode_mobile = $enable_full_screen_mode;
        }
        
        // Show correct answer mobile
        if ( isset($options['show_correct_answer_mobile']) ) {
            $show_correct_answer_mobile = $options['show_correct_answer_mobile'] == 'on' ? 'on' : 'off';
        } else {
            $show_correct_answer_mobile = $show_correct_answer;
        }
        
        // Show next button
        $options['show_next_button'] = isset($options['show_next_button']) && $options['show_next_button'] == 'off' ? 'off' : 'on';
        $show_next_button = (isset($options['show_next_button']) && $options['show_next_button'] == 'off') ?  false : true;
        // Show next button mobile
        if ( isset($options['show_next_button_mobile']) ) {
            $show_next_button_mobile = $options['show_next_button_mobile'] == 'off' ? false : true;
        } else {
            $show_next_button_mobile = $show_next_button;
        }

        //Animation effect
        $games_animation_effect = isset($options['games_animation_effect']) && $options['games_animation_effect'] != '' ? stripslashes ( esc_attr($options['games_animation_effect'])) : $games_animation_effect;        

        // Enable Animation effect Mobile
        $options['enable_games_animation_effect_mobile'] = isset($options['enable_games_animation_effect_mobile']) && $options['enable_games_animation_effect_mobile'] == 'off' ? 'off' : 'on';
        $enable_games_animation_effect_mobile = $options['enable_games_animation_effect_mobile'] == 'on' ?  true : false;
 
        //Animation effect Mobile
        $games_animation_effect_mobile = isset($options['games_animation_effect_mobile']) && $options['games_animation_effect_mobile'] != '' ? stripslashes ( esc_attr($options['games_animation_effect_mobile'])) : $games_animation_effect;
 
        // BG Color
        $bg_color = isset($options['bg_color']) && $options['bg_color'] != '' ? esc_attr($options['bg_color']) : $bg_color;
        
        // Enable BG Color Mobile
        $options['enable_bg_color_mobile'] = isset($options['enable_bg_color_mobile']) && $options['enable_bg_color_mobile'] == 'off' ? 'off' : 'on';
        $enable_bg_color_mobile = $options['enable_bg_color_mobile'] == 'on' ?  true : false;
        
        // BG Color Mobile
        $bg_color_mobile = isset($options['bg_color_mobile']) && $options['bg_color_mobile'] != '' ? esc_attr($options['bg_color_mobile']) : $bg_color;  
        
        // Main Color
        $main_color = isset($options['main_color']) && $options['main_color'] != '' ? esc_attr($options['main_color']) : $main_color;

        // Enable Main Color Mobile
        $options['enable_main_color_mobile'] = isset($options['enable_main_color_mobile']) && $options['enable_main_color_mobile'] == 'off' ? 'off' : 'on';
        $enable_main_color_mobile = $options['enable_main_color_mobile'] == 'on' ?  true : false;

        // Main Color Mobile
        $main_color_mobile = isset($options['main_color_mobile']) && $options['main_color_mobile'] != '' ? esc_attr($options['main_color_mobile']) : $main_color;
        
        // Text Color
        $text_color = isset($options['text_color']) && $options['text_color'] != '' ? esc_attr($options['text_color']) : $text_color;        

        // Enable Text Color Mobile
        $options['enable_text_color_mobile'] = isset($options['enable_text_color_mobile']) && $options['enable_text_color_mobile'] == 'off' ? 'off' : 'on';
        $enable_text_color_mobile = $options['enable_text_color_mobile'] == 'on' ?  true : false;

        // Text Color Mobile
        $text_color_mobile = isset($options['text_color_mobile']) && $options['text_color_mobile'] != '' ? esc_attr($options['text_color_mobile']) : $text_color;

        // Container Border Color
        $container_border_color   = isset($options['container_border_color']) && $options['container_border_color'] != '' ? esc_attr($options['container_border_color']) : $container_border_color;

        // Enable Text Color Mobile
        $options['enable_container_border_color_mobile'] = isset($options['enable_container_border_color_mobile']) && $options['enable_container_border_color_mobile'] == 'off' ? 'off' : 'on';
        $enable_container_border_color_mobile = $options['enable_container_border_color_mobile'] == 'on' ?  true : false;

        // Container Border Color Mobile
        $container_border_color_mobile = isset($options['container_border_color_mobile']) && $options['container_border_color_mobile'] != '' ? esc_attr($options['container_border_color_mobile']) : $container_border_color;

        $button_text_color   = isset($options['button_text_color']) && $options['button_text_color'] != '' ? esc_attr($options['button_text_color']) : $button_text_color;
        $container_border_color = isset($options['container_border_color']) && $options['container_border_color'] != '' ? esc_attr($options['container_border_color']) : $container_border_color;
        $button_font_size = isset($options['button_font_size']) && $options['button_font_size'] != '' ? esc_attr($options['button_font_size']) : $button_font_size;
        $buttons_left_right_padding = isset($options['buttons_left_right_padding']) && $options['buttons_left_right_padding'] != '' ? esc_attr($options['buttons_left_right_padding']) : $buttons_left_right_padding;
        $buttons_top_bottom_padding = isset($options['buttons_top_bottom_padding']) && $options['buttons_top_bottom_padding'] != '' ? esc_attr($options['buttons_top_bottom_padding']) : $buttons_top_bottom_padding;
        $buttons_border_radius = isset($options['buttons_border_radius']) && $options['buttons_border_radius'] != '' ? esc_attr($options['buttons_border_radius']) : $buttons_border_radius;
        
        // Container border radius
        $container_border_radius  = isset($options['container_border_radius']) && $options['container_border_radius'] != '' ? absint(esc_attr($options['container_border_radius'])) : $container_border_radius;

        // Enable Container border radius
        $options['enable_container_border_radius_mobile'] = isset($options['enable_container_border_radius_mobile']) && $options['enable_container_border_radius_mobile'] == 'off' ? 'off' : 'on';
        $enable_container_border_radius_mobile = $options['enable_container_border_radius_mobile'] == 'on' ?  true : false;

        // Container border radius Mobile
        $container_border_radius_mobile = isset($options['container_border_radius_mobile']) && $options['container_border_radius_mobile'] != '' ? stripslashes ( esc_attr($options['container_border_radius_mobile'])) : $container_border_radius;

        // Container border width
        $container_border_width  = isset($options['container_border_width']) && $options['container_border_width'] != '' ? absint(esc_attr($options['container_border_width'])) : $container_border_width;

        // Enable Container border width
        $options['enable_container_border_width_mobile'] = isset($options['enable_container_border_width_mobile']) && $options['enable_container_border_width_mobile'] == 'off' ? 'off' : 'on';
        $enable_container_border_width_mobile = $options['enable_container_border_width_mobile'] == 'on' ?  true : false;

        // Container border width Mobile
        $container_border_width_mobile = isset($options['container_border_width_mobile']) && $options['container_border_width_mobile'] != '' ? stripslashes ( esc_attr($options['container_border_width_mobile'])) : $container_border_width;

        // Container border style
        $container_border_style = isset($options['container_border_style']) && $options['container_border_style'] != '' ? stripslashes ( esc_attr($options['container_border_style'])) : $container_border_style;
        
        // Enable Container border style
        $options['enable_container_border_style_mobile'] = isset($options['enable_container_border_style_mobile']) && $options['enable_container_border_style_mobile'] == 'off' ? 'off' : 'on';
        $enable_container_border_style_mobile = $options['enable_container_border_style_mobile'] == 'on' ?  true : false;
 
        // Container border style Mobile
        $container_border_style_mobile = isset($options['container_border_style_mobile']) && $options['container_border_style_mobile'] != '' ? stripslashes ( esc_attr($options['container_border_style_mobile'])) : $container_border_style;
 
        $question_font_size = isset($options['question_font_size']) && $options['question_font_size'] != '' ? absint(esc_attr($options['question_font_size'])) : 16;
        $button_font_size_for_mobile = isset($options['button_font_size_for_mobile']) && $options['button_font_size_for_mobile'] != ''  && $options['button_font_size_for_mobile'] != 0 ? absint(esc_attr($options['button_font_size_for_mobile'])) : 16;
        $question_font_size_for_mobile = isset($options['question_font_size_for_mobile']) && $options['question_font_size_for_mobile'] != '' ? absint(esc_attr($options['question_font_size_for_mobile'])) : 16;
        $enable_container_box_shadow = (isset($options['enable_container_box_shadow']) && $options['enable_container_box_shadow'] == 'off') ? false : $enable_container_box_shadow;
        $container_box_shadow_color = (isset($options['container_box_shadow_color']) && $options['container_box_shadow_color'] != '') ? esc_attr($options['container_box_shadow_color']) : $title_text_shadow_color;   
        $container_box_shadow_x_offset = (isset($options['container_box_shadow_x_offset']) && ( $options['container_box_shadow_x_offset'] ) != '' && ( $options['container_box_shadow_x_offset'] ) != 0) ? esc_attr( intval( $options['container_box_shadow_x_offset'] ) ) : $container_box_shadow_x_offset;
        $container_box_shadow_y_offset = (isset($options['container_box_shadow_y_offset']) && ( $options['container_box_shadow_y_offset'] ) != '' && ( $options['container_box_shadow_y_offset'] ) != 0) ? esc_attr( intval( $options['container_box_shadow_y_offset'] ) ) : $container_box_shadow_y_offset;  
        $container_box_shadow_z_offset = (isset($options['container_box_shadow_z_offset']) && ( $options['container_box_shadow_z_offset'] ) != '' && ( $options['container_box_shadow_z_offset'] ) != 0) ? esc_attr( intval( $options['container_box_shadow_z_offset'] ) ) : $container_box_shadow_z_offset; 
        $enable_answer_box_shadow = (isset($options['enable_answer_box_shadow']) && $options['enable_answer_box_shadow'] == 'on') ? true : $enable_answer_box_shadow;
        $answer_box_shadow_color = (isset($options['answer_box_shadow_color']) && $options['answer_box_shadow_color'] != '') ? esc_attr($options['answer_box_shadow_color']) : 'rgba(21, 62, 113, 0.14)';
        $answer_box_shadow_x_offset = (isset($options['answer_box_shadow_x_offset']) && ( $options['answer_box_shadow_x_offset'] ) != '' && ( $options['answer_box_shadow_x_offset'] ) != 0) ? esc_attr( intval( $options['answer_box_shadow_x_offset'] ) ) : $answer_box_shadow_x_offset;
        $answer_box_shadow_y_offset = (isset($options['answer_box_shadow_y_offset']) && ( $options['answer_box_shadow_y_offset'] ) != '' && ( $options['answer_box_shadow_y_offset'] ) != 0) ? esc_attr( intval( $options['answer_box_shadow_y_offset'] ) ) : $answer_box_shadow_y_offset; 
        $answer_box_shadow_z_offset = (isset($options['answer_box_shadow_z_offset']) && ( $options['answer_box_shadow_z_offset'] ) != '' && ( $options['answer_box_shadow_z_offset'] ) != 0) ? esc_attr( intval( $options['answer_box_shadow_z_offset'] ) ) : $answer_box_shadow_z_offset;
        
        // Answer border width
        $answer_border_width = isset($options['answer_border_width']) && $options['answer_border_width'] != '' ? absint(esc_attr($options['answer_border_width'])) : $answer_border_width;
        
        // Enable Answer border width
        $options['enable_answer_border_width_mobile'] = isset($options['enable_answer_border_width_mobile']) && $options['enable_answer_border_width_mobile'] == 'off' ? 'off' : 'on';
        $enable_answer_border_width_mobile = $options['enable_answer_border_width_mobile'] == 'on' ?  true : false;

        // Answer border width Mobile
        $answer_border_width_mobile = isset($options['answer_border_width_mobile']) && $options['answer_border_width_mobile'] != '' ? stripslashes ( esc_attr($options['answer_border_width_mobile'])) : $answer_border_width;

        $answer_border_color = isset($options['answer_border_color']) && $options['answer_border_color'] != '' ? esc_attr($options['answer_border_color']) : $answer_border_color;
        $answer_bg_color   = isset($options['answer_bg_color']) && $options['answer_bg_color'] != '' ? esc_attr($options['answer_bg_color']) : $answer_bg_color;
        $answer_border_style = isset($options['answer_border_style']) && $options['answer_border_style'] != '' ? stripslashes ( esc_attr($options['answer_border_style'])) : $answer_border_style;
        $answer_font_size = isset($options['answer_font_size']) && $options['answer_font_size'] != '' ? absint(esc_attr($options['answer_font_size'])) : 15;
        $answer_font_size_for_mobile = isset($options['answer_font_size_for_mobile']) && $options['answer_font_size_for_mobile'] != '' ? absint(esc_attr($options['answer_font_size_for_mobile'])) : 15;
        $custom_class = (isset($options['custom_class']) && $options['custom_class'] != "") ? $options['custom_class'] : '';
        $custom_css = isset($options['custom_css']) && $options['custom_css'] != '' ?  stripslashes ( esc_attr($options['custom_css'])) : $custom_css ;
        $change_group_name = isset($options['change_group_name']) && $options['change_group_name'] != '' ?  stripslashes ( esc_attr($options['change_group_name'])) : $change_group_name ;
        $change_word_name = isset($options['change_word_name']) && $options['change_word_name'] != '' ?  stripslashes ( esc_attr($options['change_word_name'])) : $change_word_name ;
        $change_translation_name = isset($options['change_translation_name']) && $options['change_translation_name'] != '' ?  stripslashes ( esc_attr($options['change_translation_name'])) : $change_translation_name ;
        $pd_title = isset($options['title']) && $options['title'] != '' ?  stripslashes ( esc_attr($options['title'])) : $pd_title ;
        
        // Show PD Title
        $options['show_title'] = isset($options['show_title']) && $options['show_title'] == 'on' ? 'on' : 'off';
        $show_pd_title = (isset($options['show_title']) && $options['show_title'] == 'on') ?  true : false;
        // Show PD Title mobile
        if ( isset($options['show_title_mobile']) ) {
            $show_pd_title_mobile = $options['show_title_mobile'] == 'on' ? 'on' : 'off';
        } else {
            $show_pd_title_mobile = $show_pd_title;
        }
        // Title text shadow
        $enable_title_text_shadow = (isset($options['enable_title_text_shadow']) && $options['enable_title_text_shadow'] == 'on') ? true : false;

        $title_text_shadow_color = (isset($options['title_text_shadow_color']) && $options['title_text_shadow_color'] != '') ? esc_attr($options['title_text_shadow_color']) : 'rgba(234,234,234,0)';   

        $title_text_shadow_x_offset = (isset($options['title_text_shadow_x_offset']) && ( $options['title_text_shadow_x_offset'] ) != '' && ( $options['title_text_shadow_x_offset'] ) != 0) ? esc_attr( intval( $options['title_text_shadow_x_offset'] ) ) : 2;

        $title_text_shadow_y_offset = (isset($options['title_text_shadow_y_offset']) && ( $options['title_text_shadow_y_offset'] ) != '' && ( $options['title_text_shadow_y_offset'] ) != 0) ? esc_attr( intval( $options['title_text_shadow_y_offset'] ) ) : 2; 

        $title_text_shadow_z_offset = (isset($options['title_text_shadow_z_offset']) && ( $options['title_text_shadow_z_offset'] ) != '' && ( $options['title_text_shadow_z_offset'] ) != 0) ? esc_attr( intval( $options['title_text_shadow_z_offset'] ) ) : 2;

        // Title alignment
        $pd_title_alignment = ( isset($options['title_alignment']) && $options['title_alignment'] != "" ) ? esc_attr($options['title_alignment']) : "left";
        
        // Enable Title alignment
        $options['enable_title_alignment_mobile'] = isset($options['enable_title_alignment_mobile']) && $options['enable_title_alignment_mobile'] == 'off' ? 'off' : 'on';
        $enable_pd_title_alignment_mobile = $options['enable_title_alignment_mobile'] == 'on' ?  true : false;

        // Title alignment Mobile
        $pd_title_alignment_mobile = isset($options['title_alignment_mobile']) && $options['title_alignment_mobile'] != '' ?  esc_attr($options['title_alignment_mobile']) : $pd_title_alignment;
        
        // Description alignment
        $pd_desc_alignment = ( isset($options['desc_alignment']) && $options['desc_alignment'] != "" ) ? esc_attr($options['desc_alignment']) : "left";

        // Enable Description alignment
        $options['enable_desc_alignment_mobile'] = isset($options['enable_desc_alignment_mobile']) && $options['enable_desc_alignment_mobile'] == 'off' ? 'off' : 'on';
        $enable_pd_desc_alignment_mobile = $options['enable_desc_alignment_mobile'] == 'on' ?  true : false;

        // Description alignment Mobile
        $pd_desc_alignment_mobile = isset($options['desc_alignment_mobile']) && $options['desc_alignment_mobile'] != '' ?  esc_attr($options['desc_alignment_mobile']) : $pd_desc_alignment;

        // Answer view
        $pd_answer_view = ( isset($options['answer_view']) && $options['answer_view'] != "" ) ? esc_attr($options['answer_view']) : "grid";
        
        // Enable Answer view Mobile
        $options['enable_answer_view_mobile'] = isset($options['enable_answer_view_mobile']) && $options['enable_answer_view_mobile'] == 'off' ? 'off' : 'on';
        $enable_pd_answer_view_mobile = $options['enable_answer_view_mobile'] == 'on' ?  true : false;

        //Answer view Mobile
        $pd_answer_view_mobile = isset( $options['answer_view_mobile'] ) && $options['answer_view_mobile'] != '' ? stripslashes ( esc_attr( $options['answer_view_mobile'] ) ) : $pd_answer_view;

        // PD description
        $pd_description = ( isset($options['pd_description']) && $options['pd_description'] != "" ) ? stripslashes($options['pd_description']) : "";

        // Show description
        $options['show_description'] = isset($options['show_description']) && $options['show_description'] == 'on' ? 'on' : 'off';
        $show_pd_description = (isset($options['show_description']) && $options['show_description'] == 'on') ?  true : false;
        
        // Show PD Title mobile
        if ( isset($options['show_description_mobile']) ) {
            $show_pd_description_mobile = $options['show_description_mobile'] == 'on' ? 'on' : 'off';
        } else {
            $show_pd_description_mobile = $show_pd_description;
        }

        // Title font size
        $title_font_size    = isset($options['title_font_size']) && $options['title_font_size'] != '' ? absint(esc_attr($options['title_font_size'])) : 30;
        $title_font_size_for_mobile    = isset($options['title_font_size_for_mobile']) && $options['title_font_size_for_mobile'] != ''  && $options['title_font_size_for_mobile'] != 0 ? absint(esc_attr($options['title_font_size_for_mobile'])) : 30;

        // Description font size
        $description_font_size    = isset($options['description_font_size']) && $options['description_font_size'] != '' ? absint(esc_attr($options['description_font_size'])) : 18;
        $description_font_size_for_mobile    = isset($options['description_font_size_for_mobile']) && $options['description_font_size_for_mobile'] != ''  && $options['description_font_size_for_mobile'] != 0 ? absint(esc_attr($options['description_font_size_for_mobile'])) : 18;        
        
        //Description text shadow
        $enable_description_text_shadow = (isset($options['enable_description_text_shadow']) && $options['enable_description_text_shadow'] == 'on') ? true : false;

        // Menu Styles start
        //Menu Items
        $menu_items = isset($options['menu_items']) && $options['menu_items'] != '' ? stripslashes ( esc_attr($options['menu_items'])) : $menu_items;

        // Enable Menu Items Mobile
        $options['enable_menu_items_mobile'] = isset($options['enable_menu_items_mobile']) && $options['enable_menu_items_mobile'] == 'off' ? 'off' : 'on';
        $enable_menu_items_mobile = $options['enable_menu_items_mobile'] == 'on' ?  true : false;

        //Menu Items Mobile
        $menu_items_mobile = isset($options['menu_items_mobile']) && $options['menu_items_mobile'] != '' ? stripslashes ( esc_attr($options['menu_items_mobile'])) : $menu_items_mobile;

        //Menu Position
        $menu_position = isset($options['menu_position']) && $options['menu_position'] != '' ? stripslashes ( esc_attr($options['menu_position'])) : $menu_position;

        // Enable Menu Position Mobile
        $options['enable_menu_position_mobile'] = isset($options['enable_menu_position_mobile']) && $options['enable_menu_position_mobile'] == 'off' ? 'off' : 'on';
        $enable_menu_position_mobile = $options['enable_menu_position_mobile'] == 'on' ?  true : false;

        //Menu Position Mobiile
        $menu_position_mobile = isset($options['menu_position_mobile']) && $options['menu_position_mobile'] != '' ? stripslashes ( esc_attr($options['menu_position_mobile'])) : $menu_position_mobile;

        //Menu Layout
        $menu_layout = isset($options['menu_layout']) && $options['menu_layout'] != '' ? stripslashes ( esc_attr($options['menu_layout'])) : $menu_layout;

        // Enable Menu Layout Mobile
        $options['enable_menu_layout_mobile'] = isset($options['enable_menu_layout_mobile']) && $options['enable_menu_layout_mobile'] == 'on' ? 'on' : 'off';
        $enable_menu_layout_mobile = $options['enable_menu_layout_mobile'] == 'on' ?  true : false;

        //Menu Layout Mobiile
        $menu_layout_mobile = isset($options['menu_layout_mobile']) && $options['menu_layout_mobile'] != '' ? stripslashes ( esc_attr($options['menu_layout_mobile'])) : $menu_layout_mobile;
        // Menu Styles end

        //Answer border
        $ays_pd_enable_answer_border = isset($options['enable_answer_border'])  ? $options['enable_answer_border'] : 'on';

        $description_text_shadow_color = (isset($options['description_text_shadow_color']) && $options['description_text_shadow_color'] != '') ? esc_attr($options['description_text_shadow_color']) : 'rgba(234,234,234,0)';   

        $description_text_shadow_x_offset = (isset($options['description_text_shadow_x_offset']) && ( $options['description_text_shadow_x_offset'] ) != '' && ( $options['description_text_shadow_x_offset'] ) != 0) ? esc_attr( intval( $options['description_text_shadow_x_offset'] ) ) : 2;

        $description_text_shadow_y_offset = (isset($options['description_text_shadow_y_offset']) && ( $options['description_text_shadow_y_offset'] ) != '' && ( $options['description_text_shadow_y_offset'] ) != 0) ? esc_attr( intval( $options['description_text_shadow_y_offset'] ) ) : 2; 

        $description_text_shadow_z_offset = (isset($options['description_text_shadow_z_offset']) && ( $options['description_text_shadow_z_offset'] ) != '' && ( $options['description_text_shadow_z_offset'] ) != 0) ? esc_attr( intval( $options['description_text_shadow_z_offset'] ) ) : 2;

    }

    // Add logo
    $pd_logo = (isset($options[ 'pd_add_logo' ]) && $options[ 'pd_add_logo' ] != '') ? stripslashes ( esc_attr( $options[ 'pd_add_logo' ] ) ) : '';
    $pd_logo_text = __('Add Image', $this->plugin_name);
    if ( $pd_logo != '' ) {
        $pd_logo_text = __('Edit Image', $this->plugin_name);
    }

    // Logo position
    $pd_logo_position = (isset( $options[ 'pd_logo_pos' ] ) && $options[ 'pd_logo_pos' ] != '') ? esc_attr( $options[ 'pd_logo_pos' ] ) : 'right';

    // Logo url
    $pd_logo_image_url  = (isset($options[ 'pd_logo_url' ]) &&  $options[ 'pd_logo_url' ] != '') ? esc_attr( $options[ 'pd_logo_url' ] ) : '';

    $pd_logo_image_url_check = (isset($options[ 'pd_enable_logo_url' ]) &&  $options[ 'pd_enable_logo_url' ] == 'on') ? true : false;
    $pd_logo_image_url_checked = $pd_logo_image_url_check ? 'checked' : '';

    //Open logo URL in new tab
    $pd_logo_image_url_check_new_tab = (isset($options['pd_logo_url_new_tab' ]) &&  $options['pd_logo_url_new_tab' ] == 'on') ? "checked" : "";

    //Logo title
    $pd_logo_title = (isset($options['pd_logo_title' ]) &&  $options['pd_logo_title' ] != '') ? esc_attr( $options[ 'pd_logo_title' ] ) : "";

    $pd_accordion_svg_html = '
    <div class="ays-pd-accordion-arrow-box">
        <svg class="ays-pd-accordion-arrow ays-pd-accordion-arrow-down" version="1.2" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" overflow="visible" preserveAspectRatio="none" viewBox="0 0 24 24" width="32" height="32">
            <g>
                <path xmlns:default="http://www.w3.org/2000/svg" d="M8.59 16.34l4.58-4.59-4.58-4.59L10 5.75l6 6-6 6z" fill="#008cff" vector-effect="non-scaling-stroke" />
            </g>
        </svg>
    </div>';
?>

<div class="wrap">
    <div class="ays-pd-heading-box">
        <div class="ays-pd-wordpress-user-manual-box">
            <a href="https://ays-pro.com/wordpress-personal-dictionary-user-manual" target="_blank"><?php echo __("View Documentation", $this->plugin_name); ?>
            <i class="ays_fa ays_fa_file_text"></i>
            <span style="margin-left: 3px;text-decoration: underline;"><?php echo __("View Documentation", $this->plugin_name); ?></span>
        </a>
        </div>
    </div>
    <form method="post" id="ays-export-form">
        <div class="container-fluid">
            <h1 class="wp-heading-inline">
                <?php
                    echo __(esc_html(get_admin_page_title()),$this->plugin_name);

                    $other_attributes = array();
                    echo submit_button(__('Save', $this->plugin_name), 'primary ays-button-top ays-loader-banner', 'ays_pd_submit_top', false, $other_attributes);
                    echo $loader_iamge;
                ?>
            </h1>

            <div id="tab1" class="ays-pd-tab-content ays-pd-tab-content-active">   
                <div class="ays-pd-accordion-options-main-container" data-collapsed="false">
                    <div class="ays-pd-accordion-container">
                        <?php echo $pd_accordion_svg_html; ?>             
                        <p class="ays-pd-subtitle"><?php echo __("General settings" , $this->plugin_name)?></p>
                    </div>
                    <hr class="ays-pd-bolder-hr"/>
                    <div class="ays-pd-accordion-options-box">
                        <div class="form-group row">
                            <div class="col-sm-4">
                                <label for="ays_pd_title">
                                    <?php echo __('Title', $this->plugin_name); ?>
                                    <a class="ays_help" data-toggle="tooltip" data-placement="top" title="<?php echo __("Title of the personal dictionary", $this->plugin_name); ?>">
                                        <i class="ays_fa_pd ays_fa-info-circle"></i>
                                    </a>
                                </label>
                            </div>
                            <div class="col-sm-8 ays_divider_left">
                                <input type="text" id="ays_pd_title" class="ays-pd-title" name="ays_pd_title" value="<?php echo $pd_title;?>">
                            </div>
                        </div>
                        <hr>
                        <div class='form-group row'>
                            <div class="col-sm-4">
                                <label for='ays-pd-description'>
                                    <?php echo __('Description', $this->plugin_name); ?>
                                    <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Provide more information about the personal dictionary.',$this->plugin_name)?>">
                                        <i class="ays_fa_pd ays_fa-info-circle"></i>
                                    </a>
                                </label>
                            </div>
                            <div class="col-sm-8 ays_divider_left">
                                <?php
                                $content = $pd_description;
                                $editor_id = 'ays-pd-description';
                                $settings = array('editor_height' => $pd_wp_editor_height, 'textarea_name' => 'ays_pd_description', 'editor_class' => 'ays-textarea', 'media_elements' => false);
                                wp_editor($content, $editor_id, $settings);
                                ?>
                            </div>
                        </div>
                        <hr>
                        <div class="form-group row">
                            <div class="col-sm-4">
                                <label for="ays_pd_show_title">
                                    <?php echo __("Show title", $this->plugin_name);?>
                                    <a class="ays_help" data-toggle="tooltip" title="<?php echo __("Enable to show the title inside the dictionary.", $this->plugin_name); ?>">
                                        <i class="ays_fa_pd ays_fa-info-circle"></i>
                                    </a>
                                </label>
                            </div>
                            <div class="col-sm-8 ays_divider_left ays_pd_pc_and_mobile_container">
                                <div class="ays_pd_pc_and_mobile_container ays_pd_pc_and_mobile_container_cb">
                                    <div class="ays_pd_option_for_desktop">
                                        <span class="ays_pd_current_device_name" style="<?php echo ( $show_pd_title == 'on' || $show_pd_title_mobile == 'on' ) ? 'display: block' : '' ?>"><?php echo __('PC', $this->plugin_name) ?></span>
                                        <p class="onoffswitch">
                                            <input type="checkbox" id="ays_pd_show_title" class="ays-pd-onoffswitch-checkbox" name="ays_pd_show_title" value="on" <?php echo $show_pd_title ? 'checked' : ''; ?>>
                                        </p>
                                    </div>
                                    <div class="ays_pd_option_for_mobile_device ays_pd_option_for_mobile_device_cb ays_divider_left <?php echo ( $show_pd_title == 'on' || $show_pd_title_mobile == 'on' ) ? 'show' : '' ?>">
                                        <span class="ays_pd_current_device_name" style="<?php echo ( $show_pd_title == 'on' || $show_pd_title_mobile == 'on' ) ? 'display: block' : '' ?>"><?php echo __('Mobile', $this->plugin_name) ?></span>
                                        <p class="onoffswitch" style="margin:0;">
                                            <input type="checkbox" name="ays_pd_show_title_mobile" class="ays-pd-onoffswitch-checkbox" id="ays_pd_show_title_mobile" <?php echo $show_pd_title_mobile !== 'off' ? 'checked' : '' ?>/>
                                        </p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <hr>
                        <div class="form-group row">
                            <div class="col-sm-4">
                                <label for="ays_pd_show_description">
                                    <?php echo __("Show Description", $this->plugin_name);?>
                                    <a class="ays_help" data-toggle="tooltip" title="<?php echo __("Enable to show the description inside the dictionary.", $this->plugin_name); ?>">
                                        <i class="ays_fa_pd ays_fa-info-circle"></i>
                                    </a>
                                </label>
                            </div>
                            <div class="col-sm-8 ays_divider_left ays_pd_pc_and_mobile_container">
                                <div class="ays_pd_pc_and_mobile_container ays_pd_pc_and_mobile_container_cb">
                                    <div class="ays_pd_option_for_desktop">
                                        <span class="ays_pd_current_device_name" style="<?php echo ($show_pd_description == 'on' || $show_pd_description_mobile == 'on') ? 'display: block' : '' ?>"><?php echo __('PC', $this->plugin_name) ?></span>
                                        <p class="onoffswitch">
                                            <input type="checkbox" id="ays_pd_show_description" class="ays-pd-onoffswitch-checkbox" name="ays_pd_show_description" value="on" <?php echo $show_pd_description ? 'checked' : ''; ?>>
                                        </p>
                                    </div>
                                    <div class="ays_pd_option_for_mobile_device ays_pd_option_for_mobile_device_cb ays_divider_left <?php echo ($show_pd_description == 'on' || $show_pd_description_mobile == 'on') ? 'show' : '' ?>">
                                        <span class="ays_pd_current_device_name" style="<?php echo ($show_pd_description == 'on' || $show_pd_description_mobile == 'on') ? 'display: block' : '' ?>"><?php echo __('Mobile', $this->plugin_name) ?></span>
                                        <p class="onoffswitch" style="margin:0;">
                                            <input type="checkbox" name="ays_pd_show_description_mobile" class="ays-pd-onoffswitch-checkbox" id="ays_pd_show_description_mobile" <?php if($show_pd_description_mobile == 'on'){ echo 'checked';} ?>/>
                                        </p>
                                    </div>
                                </div>
                            </div>  

                        </div>
                        <hr>
                        <div class="form-group row">
                            <div class="col-sm-4">
                                <label for="ays_pd_add_logo">
                                    <?php echo __("Add logo", $this->plugin_name);?>
                                    <a class="ays_help" data-toggle="tooltip" title="<?php echo __("Add logo image for personal dictionary. Advisable size for image is 50x50.", $this->plugin_name); ?>">
                                        <i class="ays_fa_pd ays_fa-info-circle"></i>
                                    </a>
                                </label>
                            </div>
                            <div class="col-sm-8 ays_divider_left">
                                <div class="ays-pd-image-container">
                                    <button class="button ays-pd-add-image" type="button"><?php echo esc_attr($pd_logo_text); ?></button>
                                    <div class="ays-pd-image-body" style="<?php echo $pd_logo != '' ? '' : 'display: none;'; ?>">
                                        <div class="ays-pd-image-wrapper">
                                            <div class="ays-pd-image-wrapper-delete-wrap">
                                                <div role="button" class="ays-pd-image-wrapper-delete-cont removeImage">
                                                    <img src="<?php echo esc_attr(PERSONAL_DICTIONARY_ADMIN_URL); ?>/images/icons/close-grey.svg">
                                                </div>
                                            </div>
                                            <img class="ays-pd-img" src="<?php echo esc_url($pd_logo); ?>" tabindex="0" />
                                            <input type="hidden" class="ays-pd-img-src" id="ays_pd_add_logo" name="ays_pd_add_logo" value="<?php echo esc_attr($pd_logo); ?>">
                                        </div>
                                    </div>
                                </div>
                                <hr class="ays-pd-logo-url-box <?php echo $pd_logo != '' ? '' : 'display_none'; ?>">
                                <div class="form-group row ays-pd-logo-url-box <?php echo $pd_logo != '' ? '' : 'display_none'; ?>">
                                    <div class="col-sm-2">
                                        <label for="ays_pd_logo_enable_image_url">
                                            <?= __('Logo URL', $this->plugin_name); ?>
                                            <a class="ays_help" data-toggle="tooltip"
                                            data-placement="top"
                                            title="<?= __("Add a URL link to the image for personal dictionary.", $this->plugin_name); ?>">
                                                <i class="ays_fa_pd ays_fa-info-circle"></i>
                                            </a>
                                        </label>                                   
                                    </div>
                                    <div class="col-sm-10 ays_divider_left ">
                                        <input type="checkbox"
                                                name="ays_pd_logo_enable_image_url"
                                                id="ays_pd_logo_enable_image_url"
                                                value="on" class="ays_toggle ays_toggle_slide ays_toggle_checkbox" <?php echo esc_attr($pd_logo_image_url_checked); ?>>
                                        <label for="ays_pd_logo_enable_image_url" class="ays_switch_toggle"></label>                           
                                        <div class="row ays_toggle_target <?php echo $pd_logo != '' && $pd_logo_image_url_check ? '' : 'display_none'; ?>" style="padding: 10px 15px 0; margin-top: 10px;">
                                            <input type="text" name="ays_pd_logo_image_url" id="ays_pd_logo_image_url" value="<?php echo esc_attr($pd_logo_image_url)?>" class="ays-text-input ays-text-input-short" placeholder="URL">
                                        </div>
                                        <hr class="ays_toggle_target <?php echo $pd_logo_image_url_checked ? "" : "display_none"; ?>">
                                        <div class="row ays_toggle_target ays-poll-logo-open-close <?php echo $pd_logo_image_url_checked ? "ays_display_block" : "display_none"; ?>">
                                            <div class="col-sm-6">
                                                <label for="ays_pd_logo_enable_image_url_new_tab">
                                                    <?= __('Open in a new tab', $this->plugin_name); ?>
                                                    <a class="ays_help" data-toggle="tooltip" data-placement="top" title="<?= __("Activate this option, if you want to open the URL in a new tab.", $this->plugin_name); ?>">
                                                        <i class="ays_fa_pd ays_fa-info-circle"></i>
                                                    </a>
                                                </label> 
                                            </div>
                                            <div class="col-sm-6">
                                                <input type="checkbox"
                                                        name="ays_pd_logo_enable_image_url_new_tab"
                                                        id="ays_pd_logo_enable_image_url_new_tab"
                                                        value="on" class="ays_toggle ays_toggle_slide " <?php echo $pd_logo_image_url_check_new_tab; ?>>
                                                <label for="ays_pd_logo_enable_image_url_new_tab" class="ays_switch_toggle"></label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <hr class="ays_pd_logo_position <?php echo $pd_logo != '' ? '' : 'display_none'; ?>">
                                <div class="form-group row ays_pd_logo_position <?php echo $pd_logo != '' ? '' : 'display_none'; ?>">
                                    <div class="col-sm-2">
                                        <label for="ays_pd_logo_pos">
                                            <?php echo __("Logo position", $this->plugin_name);?>
                                            <a class="ays_help" data-toggle="tooltip" title="<?php echo __("Specify the position of the Logo image.", $this->plugin_name); ?>">
                                            <i class="ays_fa_pd ays_fa-info-circle"></i>
                                            </a>
                                        </label>
                                    </div>
                                    <div class="col-sm-10 ays_divider_left">
                                        <select class="ays-text-input ays-text-input-short" id='ays_pd_logo_pos' name='ays_pd_logo_pos'>
                                            <option value="left"   <?php echo ($pd_logo_position == 'left')   ? 'selected' : ''; ?>><?php echo __('Left', $this->plugin_name); ?></option>
                                            <option value="center" <?php echo ($pd_logo_position == 'center') ? 'selected' : ''; ?>><?php echo __('Center', $this->plugin_name); ?></option>
                                            <option value="right"  <?php echo ($pd_logo_position == 'right')  ? 'selected' : ''; ?>><?php echo __('Right', $this->plugin_name); ?></option>
                                        </select>
                                    </div>
                                </div>
                                <hr class="ays_pd_logo_position <?php echo $pd_logo != '' ? '' : 'display_none'; ?>">
                                <div class="form-group row ays_pd_logo_position <?php echo $pd_logo != '' ? '' : 'display_none'; ?>">
                                    <div class="col-sm-2">
                                        <label for="ays_pd_logo_title">
                                            <?php echo __("Logo title", $this->plugin_name);?>
                                            <a class="ays_help" data-toggle="tooltip" title="<?php echo __("Specify the title of the Logo image.", $this->plugin_name); ?>">
                                            <i class="ays_fa_pd ays_fa-info-circle"></i>
                                            </a>
                                        </label>
                                    </div>
                                    <div class="col-sm-10 ays_divider_left">
                                        <input type="text" class="ays-text-input ays-text-input-short" id='ays_pd_logo_title' name='ays_pd_logo_title' value="<?php echo esc_attr($pd_logo_title)?>">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <hr>
                        <div class="form-group row">
                            <div class="col-sm-4">
                                <label for="ays_pd_learned_points">
                                    <?php echo __('Learnt points', $this->plugin_name); ?>
                                    <a class="ays_help" data-toggle="tooltip" data-placement="top" title="<?php echo __("Specify a point value for a word to be considered learned. This option works with the right and wrong answer points options.", $this->plugin_name); ?>">
                                        <i class="ays_fa_pd ays_fa-info-circle"></i>
                                    </a>
                                </label>
                            </div>
                            <div class="col-sm-8 ays_divider_left">
                                <input type="text" id="ays_pd_learned_points" name="ays_pd_learned_points" value="<?php echo $learned_points;?>">
                            </div>
                        </div>
                        <hr>
                        <div class="form-group row">
                            <div class="col-sm-4">
                                <label for="ays_pd_right_points">
                                    <?php echo __('Right answer points', $this->plugin_name); ?>
                                    <a class="ays_help" data-toggle="tooltip" data-placement="top" title="<?php echo __("Specify the point value for users’ right answers. In case of a right answer, these points will be added to the point of the word and will positively affect the result.", $this->plugin_name); ?>">
                                        <i class="ays_fa_pd ays_fa-info-circle"></i>
                                    </a>
                                </label>
                            </div>
                            <div class="col-sm-8 ays_divider_left">
                                <input type="text" id="ays_pd_right_points" name="ays_pd_right_points" value="<?php echo $right_points;?>">
                            </div>
                        </div>
                        <hr>
                        <div class="form-group row">
                            <div class="col-sm-4">
                                <label for="ays_pd_wrong_points">
                                    <?php echo __('Wrong answer points (-)', $this->plugin_name); ?>
                                    <a class="ays_help" data-toggle="tooltip" data-placement="top" title="<?php echo __("Specify the point value for users’ wrong answers. In case of a wrong answer, these points will be added to the point of the word and will negatively affect the result.", $this->plugin_name); ?>">
                                        <i class="ays_fa_pd ays_fa-info-circle"></i>
                                    </a>
                                </label>
                            </div>
                            <div class="col-sm-8 ays_divider_left">
                                <input type="text" id="ays_pd_wrong_points" name="ays_pd_wrong_points" value="<?php echo $wrong_points;?>">
                            </div>
                        </div>
                        <hr>
                        <div class="form-group row">
                            <div class="col-sm-4">
                                <label for="ays_pd_show_correct_answer">
                                    <?php echo __('Show correct answer', $this->plugin_name); ?>
                                    <a class="ays_help" data-toggle="tooltip" data-placement="top" title="<?php echo __("Enable this option to show whether the selected answer is correct or not with green and red marks.", $this->plugin_name); ?>">
                                        <i class="ays_fa_pd ays_fa-info-circle"></i>
                                    </a>
                                </label>
                            </div>
                            <div class="col-sm-8 ays_divider_left ays_pd_pc_and_mobile_container">
                                <div class="ays_pd_pc_and_mobile_container ays_pd_pc_and_mobile_container_cb">
                                    <div class="ays_pd_option_for_desktop">
                                        <span class="ays_pd_current_device_name" style="<?php echo ($show_correct_answer == 'on' || $show_correct_answer_mobile == 'on') ? 'display: block' : '' ?>"><?php echo __('PC', $this->plugin_name) ?></span>
                                        <p class="onoffswitch">
                                            <input type="checkbox" id="ays_pd_show_correct_answer" class="ays-pd-onoffswitch-checkbox" name="ays_pd_show_correct_answer" value="on" <?php echo $show_correct_answer ? 'checked' : ''; ?>>
                                        </p>
                                    </div>
                                    <div class="ays_pd_option_for_mobile_device ays_pd_option_for_mobile_device_cb ays_divider_left <?php echo ($show_correct_answer == 'on' || $show_correct_answer_mobile == 'on') ? 'show' : '' ?>">
                                        <span class="ays_pd_current_device_name" style="<?php echo ($show_correct_answer == 'on' || $show_correct_answer_mobile == 'on') ? 'display: block' : '' ?>"><?php echo __('Mobile', $this->plugin_name) ?></span>
                                        <p class="onoffswitch" style="margin:0;">
                                            <input type="checkbox" name="ays_pd_show_correct_answer_mobile" class="ays-pd-onoffswitch-checkbox" id="ays_pd_show_correct_answer_mobile" <?php if($show_correct_answer_mobile == 'on'){ echo 'checked';} ?>/>
                                        </p>
                                    </div>
                                </div>
                            </div>   
                        </div>
                        <hr>
                        <div class="form-group row">
                            <div class="col-sm-4">
                                <label for="ays_pd_show_next_button">
                                    <?php echo __('Show next button', $this->plugin_name); ?>
                                    <a class="ays_help" data-toggle="tooltip" data-placement="top" title="<?php echo __("User can change the question forward manually. If you want to make the questions required just disable this option.", $this->plugin_name); ?>">
                                        <i class="ays_fa_pd ays_fa-info-circle"></i>
                                    </a>
                                </label>
                            </div>
                            <div class="col-sm-8 ays_divider_left ays_pd_pc_and_mobile_container">
                                <div class="ays_pd_pc_and_mobile_container ays_pd_pc_and_mobile_container_cb">
                                    <div class="ays_pd_option_for_desktop">
                                        <span class="ays_pd_current_device_name" style="<?php echo ( $show_next_button || $show_next_button_mobile ) ? 'display: block' : '' ?>"><?php echo __('PC', $this->plugin_name) ?></span>
                                        <p class="onoffswitch">
                                            <input type="checkbox" id="ays_pd_show_next_button" class="ays-pd-onoffswitch-checkbox" name="ays_pd_show_next_button" value="on" <?php echo $show_next_button ? 'checked' : ''; ?>>
                                        </p>
                                    </div>
                                    <div class="ays_pd_option_for_mobile_device ays_pd_option_for_mobile_device_cb ays_divider_left <?php echo ( $show_next_button || $show_next_button_mobile ) ? 'show' : '' ?>">
                                        <span class="ays_pd_current_device_name" style="<?php echo ( $show_next_button || $show_next_button_mobile ) ? 'display: block' : '' ?>"><?php echo __('Mobile', $this->plugin_name) ?></span>
                                        <p class="onoffswitch" style="margin:0;">
                                            <input type="checkbox" name="ays_pd_show_next_button_mobile" class="ays-pd-onoffswitch-checkbox" id="ays_pd_show_next_button_mobile" <?php echo $show_next_button_mobile ? 'checked' : '' ?>/>
                                        </p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <hr/>
                        <!-- Enable Full Screen Mode Start -->
                        <div class="form-group row">
                            <div class="col-sm-4">
                                <label for="ays_pd_enable_full_screen_mode">
                                    <?php echo __('Enable full-screen mode',$this->plugin_name)?>
                                    <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Allow the dictionary takers to enter full-screen mode by pressing the icon located in the top-right corner of the dictionary container.',$this->plugin_name)?>">
                                        <i class="ays_fa_pd ays_fa-info-circle"></i>
                                    </a>
                                </label>
                            </div>
                            <div class="col-sm-8 ays_divider_left ays_pd_pc_and_mobile_container">
                                <div class="ays_pd_pc_and_mobile_container ays_pd_pc_and_mobile_container_cb">
                                    <div class="ays_pd_option_for_desktop">
                                        <span class="ays_pd_current_device_name" style="<?php echo ( $enable_full_screen_mode == 'on' || $enable_full_screen_mode_mobile == 'on' ) ? 'display: block' : '' ?>"><?php echo __('PC', $this->plugin_name) ?></span>
                                        <p class="onoffswitch">
                                            <input type="checkbox" id="ays_pd_enable_full_screen_mode" class="ays-pd-onoffswitch-checkbox" name="ays_pd_enable_full_screen_mode" value="on" <?php echo $enable_full_screen_mode ? 'checked' : ''; ?>>
                                        </p>
                                    </div>
                                    <div class="ays_pd_option_for_mobile_device ays_pd_option_for_mobile_device_cb ays_divider_left <?php echo ( $enable_full_screen_mode == 'on' || $enable_full_screen_mode_mobile == 'on' ) ? 'show' : '' ?>">
                                        <span class="ays_pd_current_device_name" style="<?php echo ( $enable_full_screen_mode == 'on' || $enable_full_screen_mode_mobile == 'on' ) ? 'display: block' : '' ?>"><?php echo __('Mobile', $this->plugin_name) ?></span>
                                        <p class="onoffswitch" style="margin:0;">
                                            <input type="checkbox" name="ays_pd_enable_full_screen_mode_mobile" class="ays-pd-onoffswitch-checkbox" id="ays_pd_enable_full_screen_mode_mobile" <?php echo $enable_full_screen_mode_mobile !== 'off' ? 'checked' : '' ?>/>
                                        </p>
                                    </div>
                                </div>
                            </div>         
                        </div>
                        <!-- Enable Full Screen Mode End -->
                        <hr/>
                        <!-- Add Words to Dictionary from the front-end Start -->
                        <div class="form-group row">
                            <div class="col-sm-4">
                                <label for="ays_pd_enable_add_words_from_front">
                                    <?php echo __('Add Words to Dictionary from the front-end',$this->plugin_name)?>
                                    <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Enable this option to add the selected words to the Dictionary from the front-end.',$this->plugin_name)?>">
                                        <i class="ays_fa_pd ays_fa-info-circle"></i>
                                    </a>
                                </label>
                            </div>
                            <div class="col-sm-8 ays_divider_left">
                                <input type="checkbox" class="ays-enable-timer1" id="ays_pd_enable_add_words_from_front" name="ays_pd_enable_add_words_from_front" value="on" <?php echo ($enable_add_words_from_front == 'on') ? 'checked' : '' ?>/>
                            </div>
                        </div>
                        <!-- Add Words to Dictionary from the front-end End -->
                        <hr>
                        <!-- Add Iamge, Audio to Dictionary from the front-end Start -->
                        <div class="form-group row">
                            <div class="col-sm-4">
                                <label for="ays_pd_enable_add_image_audio_from_front">
                                    <?php echo __(' Add Media to Dictionary Words',$this->plugin_name)?>
                                    <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Enable this option and allow adding images and audio to the words in the dictionary.',$this->plugin_name)?>">
                                        <i class="ays_fa_pd ays_fa-info-circle"></i>
                                    </a>
                                </label>
                            </div>
                            <div class="col-sm-8 ays_divider_left">
                                <div class="ays_pd_image_audio_container">
                                    <div class="ays_pd_image_option">
                                        <span class=""><?php echo __('Image', $this->plugin_name) ?></span>
                                        <p class="onoffswitch">
                                            <input type="checkbox" class="ays-enable-timer1 ays-pd-onoffswitch-checkbox" id="ays_pd_enable_add_image_from_front" name="ays_pd_enable_add_image_from_front" value="on" <?php echo ($enable_add_image_from_front == 'on') ? 'checked' : '' ?>/>
                                        </p>  
                                    </div>
                                    <div class="ays_pd_audio_option ays_divider_left">
                                        <span class=""><?php echo __('Audio', $this->plugin_name) ?></span>
                                        <p class="onoffswitch" style="margin:0;">
                                            <input type="checkbox" class="ays-enable-timer1 ays-pd-onoffswitch-checkbox" id="ays_pd_enable_add_audio_from_front" name="ays_pd_enable_add_audio_from_front" value="on" <?php echo ($enable_add_audio_from_front == 'on') ? 'checked' : '' ?>/>
                                        </p>  
                                    </div>
                                </div>    
                            </div>     
                        </div>
                        <!-- Add Iamge, Audio to Dictionary from the front-end End -->
                        <hr>
                        <!-- Add Iamge, Audio to Dictionary to games --> 
                        <div class="form-group row ays_pd_show_media" style="<?php echo ( $enable_add_image_from_front == 'on' || $enable_add_audio_from_front == 'on' ) ? '' : 'display:none';?>">
                            <div class="col-sm-4">
                                <label for="ays_pd_enable_add_image_audio_from_front">
                                    <?php echo __('Add Media to Games',$this->plugin_name)?>
                                    <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Enable this option to add media (images and audios) to the games. Note: You can add images to the Find word, Write translation, and Find translation games and audio to the Find word and Write translation games.',$this->plugin_name)?>">
                                        <i class="ays_fa_pd ays_fa-info-circle"></i>
                                    </a>
                                </label>
                            </div>
                            <div class="col-sm-8 ays_divider_left ays_toggle_parent">
                                <div class="ays_pd_image_audio_container">
                                    <div class="ays_pd_image_option_game">
                                        <span class=""><?php echo __('Add Image to Games', $this->plugin_name) ?></span>
                                        <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Enable this checkbox to add images to the Find word, Write translation, and Find translation games.',$this->plugin_name)?>">
                                            <i class="ays_fa_pd ays_fa-info-circle"></i>
                                        </a>
                                        <p class="onoffswitch">
                                            <input type="checkbox" class="ays-enable-timer1 ays-pd-onoffswitch-checkbox" id="ays_pd_enable_add_image_to_games" name="ays_pd_enable_add_image_to_games" value="on" <?php echo ($enable_add_image_to_games == 'on') ? 'checked' : '' ?> <?php echo ($enable_add_image_from_front == 'off') ? 'disabled' : '' ?>/>
                                        </p>  
                                    </div>
                                    <div class="ays_pd_audio_option_game ays_divider_left">
                                        <span class=""><?php echo __('Add Audio to Games', $this->plugin_name) ?></span>
                                        <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Enable this checkbox to add audio to the Find word and Write translation games.',$this->plugin_name)?>">
                                            <i class="ays_fa_pd ays_fa-info-circle"></i>
                                        </a>
                                        <p class="onoffswitch" style="margin:0;">
                                            <input type="checkbox" class="ays-enable-timer1 ays-pd-onoffswitch-checkbox" id="ays_pd_enable_add_audio_to_games" name="ays_pd_enable_add_audio_to_games" value="on" <?php echo ($enable_add_audio_to_games == 'on') ? 'checked' : '' ?> <?php echo ($enable_add_audio_from_front == 'off') ? 'disabled' : '' ?>/>
                                        </p>  
                                    </div>
                                </div>    
                            </div>                               
                        </div>
                        <hr  class="ays_pd_show_media" style="<?php echo ( $enable_add_image_from_front == 'on' || $enable_add_audio_from_front == 'on' ) ? '' : 'display:none';?>">
                        <!-- Add Iamge, Audio to Dictionary to games -->
                        <!-- Show Games Start -->
                        <div class="form-group row">
                            <div class="col-sm-4">
                                <label for="ays_pd_show_games">
                                    <?php echo __('Show Games',$this->plugin_name)?>
                                    <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Enable this option to display games on the front-end. You can choose to show/hide the particular game by ticking/unticking the checkbox.',$this->plugin_name)?>">
                                        <i class="ays_fa_pd ays_fa-info-circle"></i>
                                    </a>
                                </label>
                            </div>
                            <div class="col-sm-8 ays_divider_left ays_toggle_parent">
                                <input type="checkbox" class="ays_toggle ays_toggle_slide" id="ays_pd_show_games"
                                        name="ays_pd_show_games" <?php echo ($show_games == 'on') ? 'checked' : '' ?>/>
                                <label for="ays_pd_show_games" class="ays_switch_toggle"></label>
                                <div class="ays_pd_show_games_container ays_toggle_target <?php echo ($show_games == 'on') ? '' : 'display_none' ?>">
                                    <hr>
                                    <div style="max-width: 200px">
                                        <label for="ays_pd_show_game_find_the_word" style="margin-right: 5px"><?php echo __('Find the word', $this->plugin_name)?></label>
                                        <input type="checkbox" class="ays-enable-timer1" id="ays_pd_show_game_find_the_word" name="ays_pd_show_game_find_the_word" <?php echo ($show_game_find_the_word == 'on') ? 'checked' : '' ?>>
                                    </div>
                                    <hr>
                                    <div style="max-width: 200px">
                                        <label for="ays_pd_show_game_find_the_translation" style="margin-right: 5px"><?php echo __('Find the translation', $this->plugin_name)?></label>
                                        <input type="checkbox" class="ays-enable-timer1" id="ays_pd_show_game_find_the_translation" name="ays_pd_show_game_find_the_translation" <?php echo ($show_game_find_the_translation == 'on') ? 'checked' : '' ?>>
                                    </div>
                                    <hr>
                                    <div style="max-width: 200px">
                                        <label for="ays_pd_show_game_matching_words" style="margin-right: 5px"><?php echo __('Matching words', $this->plugin_name)?></label>
                                        <input type="checkbox" class="ays-enable-timer1" id="ays_pd_show_game_matching_words" name="ays_pd_show_game_matching_words" <?php echo ($show_game_matching_words == 'on') ? 'checked' : '' ?>>
                                    </div>
                                    <hr>
                                    <div style="max-width: 200px">
                                        <label for="ays_pd_show_game_write_the_translation" style="margin-right: 5px"><?php echo __('Write the translation', $this->plugin_name)?></label>
                                        <input type="checkbox" class="ays-enable-timer1" id="ays_pd_show_game_write_the_translation" name="ays_pd_show_game_write_the_translation" <?php echo ($show_game_write_the_translation == 'on') ? 'checked' : '' ?>>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- Show Games End -->
                    </div>
                </div>
                <div class="ays-pd-accordion-options-main-container" data-collapsed="false">
                    <div class="ays-pd-accordion-container">    
                        <?php echo $pd_accordion_svg_html; ?>    
                        <p class="ays-pd-subtitle"><?php echo __("Styles" , $this->plugin_name)?></p>
                    </div>
                    <hr class="ays-pd-bolder-hr"/>
                    <div class="ays-pd-accordion-options-box"> 
                        <!-- Animation effect start -->
                        <div class="form-group row">
                            <div class="col-sm-4">
                                <label for='ays_pd_games_animation_effect'>
                                    <?php echo __('Animation effect', $this->plugin_name); ?>
                                    <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Animation effect of transition between questions.',$this->plugin_name)?>">
                                        <i class="ays_fa_pd ays_fa-info-circle"></i>
                                    </a>
                                </label>
                            </div>
                            <div class="col-sm-8 ays_divider_left">
                                <div class="ays_toggle_parent">
                                    <div>
                                        <div class="ays_pd_current_device_name ays_pd_current_device_name_pc_default_on ays_pd_current_device_name_pc show ays_toggle_target" style="<?php echo ($enable_games_animation_effect_mobile) ? '' : 'display: none;' ?> text-align: center; margin-bottom: 10px; max-width: 200px;"><?php echo __('PC', $this->plugin_name) ?></div>
                                        <select class="ays-text-input ays-text-input-short" name="ays_pd_games_animation_effect" id="ays_pd_games_animation_effect">
                                            <option <?php echo $games_animation_effect == "none" ? "selected" : ""; ?> value="none"><?php echo __("None", $this->plugin_name); ?></option>
                                            <option <?php echo $games_animation_effect == "fade" ? "selected" : ""; ?> value="fade"><?php echo __("Fade", $this->plugin_name); ?></option>
                                            <option <?php echo $games_animation_effect == "shake" ? "selected" : ""; ?> value="shake"><?php echo __("Shake", $this->plugin_name); ?></option>
                                        </select>                                
                                    </div>
                                    <div class="ays_toggle_target ays_pd_games_animation_effect_mobile_container" style=" <?php echo ( $enable_games_animation_effect_mobile ) ? '' : 'display:none'; ?>">
                                        <hr>
                                        <div class="ays_pd_current_device_name show" style="text-align: center; margin-bottom: 10px; max-width: 200px;"><?php echo __('Mobile', $this->plugin_name) ?></div>
                                        <select class="ays-text-input ays-text-input-short" name="ays_pd_games_animation_effect_mobile" id="ays_pd_games_animation_effect_mobile">
                                            <option <?php echo $games_animation_effect_mobile == "none" ? "selected" : ""; ?> value="none"><?php echo __("None", $this->plugin_name); ?></option>
                                            <option <?php echo $games_animation_effect_mobile == "fade" ? "selected" : ""; ?> value="fade"><?php echo __("Fade", $this->plugin_name); ?></option>
                                            <option <?php echo $games_animation_effect_mobile == "shake" ? "selected" : ""; ?> value="shake"><?php echo __("Shake", $this->plugin_name); ?></option>
                                        </select>                                
                                    </div>
                                    <div class="ays_pd_mobile_settings_container">
                                        <input type="checkbox" class="ays_toggle_mobile_checkbox" id="ays_pd_enable_games_animation_effect_mobile" name="ays_pd_enable_games_animation_effect_mobile" <?php echo $enable_games_animation_effect_mobile ? 'checked' : '' ?>>
                                        <label for="ays_pd_enable_games_animation_effect_mobile" ><?php echo __('Use a different setting for Mobile', $this->plugin_name) ?></label>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- Animation effect end -->
                        <hr>    
                        <div class="form-group row">
                            <div class="col-sm-4">
                                <label for="ays_pd_bg_color">
                                    <?php echo __('Background Color', $this->plugin_name); ?>
                                    <a class="ays_help" data-toggle="tooltip" data-placement="top" title="<?php echo __("On the color picker, choose the background color of your dictionary and make it opaque if you wish. If you Clear the color, it will take the default value – white.", $this->plugin_name); ?>">
                                        <i class="ays_fa_pd ays_fa-info-circle"></i>
                                    </a>
                                </label>
                            </div>
                            <div class="col-sm-8 ays_divider_left">
                            <div class="ays_toggle_parent">
                                    <div>
                                        <div class="ays_pd_current_device_name ays_pd_current_device_name_pc_default_on ays_pd_current_device_name_pc show ays_toggle_target" style="<?php echo ($enable_bg_color_mobile) ? '' : 'display: none;' ?> text-align: center; margin-bottom: 10px; max-width: 100px;"><?php echo __('PC', $this->plugin_name) ?></div>
                                        <input type="text" id="ays_pd_bg_color" name="ays_pd_bg_color" data-alpha="true" value="<?php echo $bg_color; ?>">
                                    </div>
                                    <div class="ays_toggle_target ays_pd_bg_color_mobile_container" style=" <?php echo ( $enable_bg_color_mobile ) ? '' : 'display:none'; ?>">
                                        <hr>
                                        <div class="ays_pd_current_device_name show" style="text-align: center; margin-bottom: 10px; max-width: 100px;"><?php echo __('Mobile', $this->plugin_name) ?></div>
                                        <input type="text" id="ays_pd_bg_color_mobile" name="ays_pd_bg_color_mobile" data-alpha="true" value="<?php echo $bg_color_mobile; ?>">
                                    </div>
                                    <div class="ays_pd_mobile_settings_container">
                                        <input type="checkbox" class="ays_toggle_mobile_checkbox" id="ays_pd_enable_bg_color_mobile" name="ays_pd_enable_bg_color_mobile" <?php echo $enable_bg_color_mobile ? 'checked' : '' ?>>
                                        <label for="ays_pd_enable_bg_color_mobile" ><?php echo __('Use a different setting for Mobile', $this->plugin_name) ?></label>
                                    </div>
                                </div>
                            </div>           
                        </div>
                        <hr>
                        <div class="form-group row">
                            <div class="col-sm-4">
                                <label for="ays_pd_main_color">
                                    <?php echo __('Main Color', $this->plugin_name); ?>
                                    <a class="ays_help" data-toggle="tooltip" data-placement="top" title="<?php echo __("On the color picker, choose the main color of your dictionary and make it opaque if you wish. If you Clear the color, it will take the default value – blue.", $this->plugin_name); ?>">
                                        <i class="ays_fa_pd ays_fa-info-circle"></i>
                                    </a>
                                </label>
                            </div>
                            <div class="col-sm-8 ays_divider_left">
                            <div class="ays_toggle_parent">
                                    <div>
                                        <div class="ays_pd_current_device_name ays_pd_current_device_name_pc_default_on ays_pd_current_device_name_pc show ays_toggle_target" style="<?php echo ($enable_main_color_mobile) ? '' : 'display: none;' ?> text-align: center; margin-bottom: 10px; max-width: 100px;"><?php echo __('PC', $this->plugin_name) ?></div>
                                        <input type="text" id="ays_pd_main_color" name="ays_pd_main_color" data-alpha="true" value="<?php echo $main_color; ?>">
                                    </div>
                                    <div class="ays_toggle_target ays_pd_main_color_mobile_container" style=" <?php echo ( $enable_main_color_mobile ) ? '' : 'display:none'; ?>">
                                        <hr>
                                        <div class="ays_pd_current_device_name show" style="text-align: center; margin-bottom: 10px; max-width: 100px;"><?php echo __('Mobile', $this->plugin_name) ?></div>
                                        <input type="text" id="ays_pd_main_color_mobile" name="ays_pd_main_color_mobile" data-alpha="true" value="<?php echo $main_color_mobile; ?>">
                                    </div>
                                    <div class="ays_pd_mobile_settings_container">
                                        <input type="checkbox" class="ays_toggle_mobile_checkbox" id="ays_pd_enable_main_color_mobile" name="ays_pd_enable_main_color_mobile" <?php echo $enable_main_color_mobile ? 'checked' : '' ?>>
                                        <label for="ays_pd_enable_main_color_mobile" ><?php echo __('Use a different setting for Mobile', $this->plugin_name) ?></label>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <hr>
                        <div class="form-group row">
                            <div class="col-sm-4">
                                <label for="ays_pd_text_color">
                                    <?php echo __('Text Color', $this->plugin_name); ?>
                                    <a class="ays_help" data-toggle="tooltip" data-placement="top" title="<?php echo __("On the color picker, choose the text color of your dictionary and make it opaque if you wish. If you Clear the color, it will take the default value – black.", $this->plugin_name); ?>">
                                        <i class="ays_fa_pd ays_fa-info-circle"></i>
                                    </a>
                                </label>
                            </div>
                            <div class="col-sm-8 ays_divider_left">
                                <div class="ays_toggle_parent">
                                    <div>
                                        <div class="ays_pd_current_device_name ays_pd_current_device_name_pc_default_on ays_pd_current_device_name_pc show ays_toggle_target" style="<?php echo ($enable_text_color_mobile) ? '' : 'display: none;' ?> text-align: center; margin-bottom: 10px; max-width: 100px;"><?php echo __('PC', $this->plugin_name) ?></div>
                                        <input type="text" id="ays_pd_text_color" name="ays_pd_text_color" data-alpha="true" value="<?php echo $text_color; ?>">
                                    </div>
                                    <div class="ays_toggle_target ays_pd_text_color_mobile_container" style=" <?php echo ( $enable_text_color_mobile ) ? '' : 'display:none'; ?>">
                                        <hr>
                                        <div class="ays_pd_current_device_name show" style="text-align: center; margin-bottom: 10px; max-width: 100px;"><?php echo __('Mobile', $this->plugin_name) ?></div>
                                        <input type="text" id="ays_pd_text_color_mobile" name="ays_pd_text_color_mobile" data-alpha="true" value="<?php echo $text_color_mobile; ?>">
                                    </div>
                                    <div class="ays_pd_mobile_settings_container">
                                        <input type="checkbox" class="ays_toggle_mobile_checkbox" id="ays_pd_enable_text_color_mobile" name="ays_pd_enable_text_color_mobile" <?php echo $enable_text_color_mobile ? 'checked' : '' ?>>
                                        <label for="ays_pd_enable_text_color_mobile" ><?php echo __('Use a different setting for Mobile', $this->plugin_name) ?></label>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <hr>
                        <!-- Container Border radius -->
                        <div class="form-group row">
                            <div class="col-sm-4">
                                <label for="ays_pd_container_border_radius">
                                    <?php echo __('Container border-radius',$this->plugin_name)?>
                                    <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Dictionary container border-radius in pixels. It accepts only numeric values.',$this->plugin_name)?>">
                                        <i class="ays_fa_pd ays_fa-info-circle"></i>
                                    </a>
                                </label>
                            </div>
                            <div class="col-sm-8 ays_divider_left">
                                <div class="ays_toggle_parent">
                                    <div>
                                        <div class="ays_pd_current_device_name ays_pd_current_device_name_pc_default_on ays_pd_current_device_name_pc show ays_toggle_target" style="<?php echo ($enable_container_border_radius_mobile) ? '' : 'display: none;' ?> text-align: center; margin-bottom: 10px; max-width: 200px;">
                                            <?php echo __('PC', $this->plugin_name) ?>
                                        </div>
                                        <div class="ays_divider_left ays_pd_display_flex_width">
                                            <div>
                                            <input type="number" id="ays_pd_container_border_radius" name="ays_pd_container_border_radius" value="<?php echo $container_border_radius; ?>"/>
                                            </div>
                                            <div class="ays_pd_dropdown_max_width">
                                                <input type="text" value="px" class="ays-pd-form-hint-for-size" disabled="">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="ays_toggle_target ays_pd_menu_position_mobile_container" style=" <?php echo ( $enable_container_border_radius_mobile ) ? '' : 'display:none'; ?>">
                                        <hr>
                                        <div class="ays_pd_current_device_name show" style="text-align: center; margin-bottom: 10px; max-width: 200px;">
                                            <?php echo __('Mobile', $this->plugin_name) ?>
                                        </div>
                                    <div class="ays_divider_left ays_pd_display_flex_width">
                                            <div>
                                            <input type="number" id="ays_pd_container_border_radius_mobile" name="ays_pd_container_border_radius_mobile" value="<?php echo $container_border_radius_mobile; ?>"/>
                                            </div>
                                            <div class="ays_pd_dropdown_max_width">
                                                <input type="text" value="px" class="ays-pd-form-hint-for-size" disabled="">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="ays_pd_mobile_settings_container">
                                        <input type="checkbox" class="ays_toggle_mobile_checkbox" id="ays_pd_enable_container_border_radius_mobile" name="ays_pd_enable_container_border_radius_mobile" <?php echo $enable_container_border_radius_mobile ? 'checked' : '' ?>>
                                        <label for="ays_pd_enable_container_border_radius_mobile" ><?php echo __('Use a different setting for Mobile', $this->plugin_name) ?></label>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <hr>
                        <!-- Container Border width -->
                        <div class="form-group row">
                            <div class="col-sm-4">
                                <label for="ays_pd_container_border_width">
                                    <?php echo __('Container border width',$this->plugin_name)?>
                                    <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Dictionary container border width in pixels. It accepts only numeric values.',$this->plugin_name)?>">
                                        <i class="ays_fa_pd ays_fa-info-circle"></i>
                                    </a>
                                </label>
                            </div>
                            <div class="col-sm-8 ays_divider_left">
                                <div class="ays_toggle_parent">
                                    <div>
                                        <div class="ays_pd_current_device_name ays_pd_current_device_name_pc_default_on ays_pd_current_device_name_pc show ays_toggle_target" style="<?php echo ($enable_container_border_width_mobile) ? '' : 'display: none;' ?> text-align: center; margin-bottom: 10px; max-width: 200px;">
                                            <?php echo __('PC', $this->plugin_name) ?>
                                        </div>
                                        <div class="ays_divider_left ays_pd_display_flex_width">
                                            <div>
                                            <input type="number" id="ays_pd_container_border_width" name="ays_pd_container_border_width" value="<?php echo $container_border_width; ?>"/>
                                            </div>
                                            <div class="ays_pd_dropdown_max_width">
                                                <input type="text" value="px" class="ays-pd-form-hint-for-size" disabled="">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="ays_toggle_target ays_pd_menu_position_mobile_container" style=" <?php echo ( $enable_container_border_width_mobile ) ? '' : 'display:none'; ?>">
                                        <hr>
                                        <div class="ays_pd_current_device_name show" style="text-align: center; margin-bottom: 10px; max-width: 200px;">
                                            <?php echo __('Mobile', $this->plugin_name) ?>
                                        </div>
                                        <div class="ays_divider_left ays_pd_display_flex_width">
                                            <div>
                                            <input type="number" id="ays_pd_container_border_width_mobile" name="ays_pd_container_border_width_mobile" value="<?php echo $container_border_width_mobile; ?>"/>
                                            </div>
                                            <div class="ays_pd_dropdown_max_width">
                                                <input type="text" value="px" class="ays-pd-form-hint-for-size" disabled="">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="ays_pd_mobile_settings_container">
                                        <input type="checkbox" class="ays_toggle_mobile_checkbox" id="ays_pd_enable_container_border_width_mobile" name="ays_pd_enable_container_border_width_mobile" <?php echo $enable_container_border_width_mobile ? 'checked' : '' ?>>
                                        <label for="ays_pd_enable_container_border_width_mobile" ><?php echo __('Use a different setting for Mobile', $this->plugin_name) ?></label>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <hr>
                        <!-- Container Border style -->
                        <div class="form-group row">
                            <div class="col-sm-4">
                                <label for="ays_pd_container_border_style">
                                    <?php echo __('Container border style',$this->plugin_name)?>
                                    <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Choose your preferred style of the border.',$this->plugin_name)?>">
                                        <i class="ays_fa_pd ays_fa-info-circle"></i>
                                    </a>
                                </label>
                            </div>
                            <div class="col-sm-8 ays_divider_left">
                                <div class="ays_toggle_parent">
                                    <div>
                                        <div class="ays_pd_current_device_name ays_pd_current_device_name_pc_default_on ays_pd_current_device_name_pc show ays_toggle_target" style="<?php echo ($enable_container_border_style_mobile) ? '' : 'display: none;' ?> text-align: center; margin-bottom: 10px; max-width: 200px;"><?php echo __('PC', $this->plugin_name) ?></div>
                                        <select name="ays_pd_container_border_style" id="ays_pd_container_border_style" class="ays-text-input ays-text-input-short">
                                            <option value="solid" <?php echo $container_border_style == "solid" ? 'selected' : ''; ?>>
                                                <?php echo __("Solid", $this->plugin_name); ?>
                                            </option>
                                            <option value="dashed" <?php echo $container_border_style == "dashed" ? 'selected' : ''; ?>>
                                                <?php echo __("Dashed", $this->plugin_name); ?>
                                            </option>
                                            <option value="dotted" <?php echo $container_border_style == "dotted" ? 'selected' : ''; ?>>
                                                <?php echo __("Dotted", $this->plugin_name); ?>
                                            </option>
                                            <option value="double" <?php echo $container_border_style == "double" ? 'selected' : ''; ?>>
                                                <?php echo __("Double", $this->plugin_name); ?>
                                            </option>
                                            <option value="groove" <?php echo $container_border_style == "groove" ? 'selected' : ''; ?>>
                                                <?php echo __("Groove", $this->plugin_name); ?>
                                            </option>
                                            <option value="ridge" <?php echo $container_border_style == "ridge" ? 'selected' : ''; ?>>
                                                <?php echo __("Ridge", $this->plugin_name); ?>
                                            </option>
                                            <option value="inset" <?php echo $container_border_style == "inset" ? 'selected' : ''; ?>>
                                                <?php echo __("Inset", $this->plugin_name); ?>
                                            </option>
                                            <option value="outset" <?php echo $container_border_style == "outset" ? 'selected' : ''; ?>>
                                                <?php echo __("Outset", $this->plugin_name); ?>
                                            </option>
                                            <option value="none" <?php echo $container_border_style == "none" ? 'selected' : ''; ?>>
                                                <?php echo __("None", $this->plugin_name); ?>
                                            </option>
                                        </select>
                                    </div>
                                    <div class="ays_toggle_target ays_pd_container_border_style_mobile_container" style=" <?php echo ( $enable_container_border_style_mobile ) ? '' : 'display:none'; ?>">
                                        <hr>
                                        <div class="ays_pd_current_device_name show" style="text-align: center; margin-bottom: 10px; max-width: 200px;"><?php echo __('Mobile', $this->plugin_name) ?></div>
                                        <select name="ays_pd_container_border_style_mobile" id="ays_pd_container_border_style_mobile" class="ays-text-input ays-text-input-short">
                                            <option value="solid" <?php echo $container_border_style_mobile == "solid" ? 'selected' : ''; ?>>
                                                <?php echo __("Solid", $this->plugin_name); ?>
                                            </option>
                                            <option value="dashed" <?php echo $container_border_style_mobile == "dashed" ? 'selected' : ''; ?>>
                                                <?php echo __("Dashed", $this->plugin_name); ?>
                                            </option>
                                            <option value="dotted" <?php echo $container_border_style_mobile == "dotted" ? 'selected' : ''; ?>>
                                                <?php echo __("Dotted", $this->plugin_name); ?>
                                            </option>
                                            <option value="double" <?php echo $container_border_style_mobile == "double" ? 'selected' : ''; ?>>
                                                <?php echo __("Double", $this->plugin_name); ?>
                                            </option>
                                            <option value="groove" <?php echo $container_border_style_mobile == "groove" ? 'selected' : ''; ?>>
                                                <?php echo __("Groove", $this->plugin_name); ?>
                                            </option>
                                            <option value="ridge" <?php echo $container_border_style_mobile == "ridge" ? 'selected' : ''; ?>>
                                                <?php echo __("Ridge", $this->plugin_name); ?>
                                            </option>
                                            <option value="inset" <?php echo $container_border_style_mobile == "inset" ? 'selected' : ''; ?>>
                                                <?php echo __("Inset", $this->plugin_name); ?>
                                            </option>
                                            <option value="outset" <?php echo $container_border_style_mobile == "outset" ? 'selected' : ''; ?>>
                                                <?php echo __("Outset", $this->plugin_name); ?>
                                            </option>
                                            <option value="none" <?php echo $container_border_style_mobile == "none" ? 'selected' : ''; ?>>
                                                <?php echo __("None", $this->plugin_name); ?>
                                            </option>
                                        </select>
                                    </div>
                                    <div class="ays_pd_mobile_settings_container">
                                        <input type="checkbox" class="ays_toggle_mobile_checkbox" id="ays_pd_enable_container_border_style_mobile" name="ays_pd_enable_container_border_style_mobile" <?php echo $enable_container_border_style_mobile ? 'checked' : '' ?>>
                                        <label for="ays_pd_enable_container_border_style_mobile" ><?php echo __('Use a different setting for Mobile', $this->plugin_name) ?></label>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <hr>
                        <!-- Container Border color -->
                        <div class="form-group row">
                            <div class="col-sm-4">
                                <label for="ays_pd_container_border_color">
                                    <?php echo __('Container border color', $this->plugin_name); ?>
                                    <a class="ays_help" data-toggle="tooltip" data-placement="top" title="<?php echo __("On the color picker, choose the container border color of your dictionary and make it opaque if you wish. If you Clear the color, it will take the default value – Silver.", $this->plugin_name); ?>">
                                        <i class="ays_fa_pd ays_fa-info-circle"></i>
                                    </a>
                                </label>
                            </div>
                            <div class="col-sm-8 ays_divider_left">
                                <div class="ays_toggle_parent">
                                    <div>
                                        <div class="ays_pd_current_device_name ays_pd_current_device_name_pc_default_on ays_pd_current_device_name_pc show ays_toggle_target" style="<?php echo ($enable_container_border_color_mobile) ? '' : 'display: none;' ?> text-align: center; margin-bottom: 10px; max-width: 100px;"><?php echo __('PC', $this->plugin_name) ?></div>
                                        <input type="text" id="ays_pd_container_border_color" name="ays_pd_container_border_color" data-alpha="true" value="<?php echo $container_border_color; ?>">
                                    </div>
                                    <div class="ays_toggle_target ays_pd_container_border_color_mobile_container" style=" <?php echo ( $enable_container_border_color_mobile ) ? '' : 'display:none'; ?>">
                                        <hr>
                                        <div class="ays_pd_current_device_name show" style="text-align: center; margin-bottom: 10px; max-width: 100px;"><?php echo __('Mobile', $this->plugin_name) ?></div>
                                        <input type="text" id="ays_pd_container_border_color_mobile" name="ays_pd_container_border_color_mobile" data-alpha="true" value="<?php echo $container_border_color_mobile; ?>">
                                    </div>
                                    <div class="ays_pd_mobile_settings_container">
                                        <input type="checkbox" class="ays_toggle_mobile_checkbox" id="ays_pd_enable_container_border_color_mobile" name="ays_pd_enable_container_border_color_mobile" <?php echo $enable_container_border_color_mobile ? 'checked' : '' ?>>
                                        <label for="ays_pd_enable_container_border_color_mobile" ><?php echo __('Use a different setting for Mobile', $this->plugin_name) ?></label>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <hr>
                        <!-- Container box-shadow start -->
                        <div class="form-group row">
                            <div class="col-sm-4">
                                <label for="ays_pd_enable_container_box_shadow">
                                    <?php echo __('Container box shadow',$this->plugin_name)?>
                                    <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Specify the box shadow of the personal dictionary container.',$this->plugin_name)?>">
                                        <i class="ays_fa_pd ays_fa-info-circle"></i>
                                    </a>
                                </label>
                            </div>
                            <div class="col-sm-8 ays_divider_left">
                                <input type="checkbox" class="ays_toggle ays_toggle_slide" id="ays_pd_enable_container_box_shadow" name="ays_pd_enable_container_box_shadow" <?php echo ($enable_container_box_shadow == 'on') ? 'checked' : ''; ?>/>
                                <label for="ays_pd_enable_container_box_shadow" class="ays_switch_toggle">Toggle</label>
                                <div class="col-sm-12 ays_toggle_target ays_divider_top <?php echo ($enable_container_box_shadow == 'on') ? '' : 'display_none'; ?>" style="margin-top: 10px; padding-top: 10px;">
                                    <div class="form-group row">
                                        <div class="col-sm-12">
                                            <label for="ays_pd_container_box_shadow_color">
                                                <?php echo __('Box shadow color',$this->plugin_name)?>
                                                <a class="ays_help" data-toggle="tooltip" title="<?php echo __('The color of the box shadow of the container.',$this->plugin_name ); ?>">
                                                <i class="ays_fa_pd ays_fa-info-circle"></i>
                                                </a>
                                            </label>
                                            <input type="text" id="ays_pd_container_box_shadow_color" name="ays_pd_container_box_shadow_color" data-alpha="true" value="<?php echo $container_box_shadow_color; ?>">
                                        </div>
                                    </div>
                                    <hr>
                                    <div class="form-group row">
                                        <div class="col-sm-12">
                                            <div class="col-sm-3" style="display: inline-block;">
                                                <span class="ays_pd_small_hint_text"><?php echo __('X', $this->plugin_name); ?></span>
                                                <input type="number" class="ays-text-input ays-text-input-90-width" id='ays_pd_container_box_shadow_x_offset' name='ays_pd_container_box_shadow_x_offset' value='<?php echo $container_box_shadow_x_offset; ?>' />
                                            </div>
                                            <div class="col-sm-3 ays_divider_left" style="display: inline-block;">
                                                <span class="ays_pd_small_hint_text"><?php echo __('Y', $this->plugin_name); ?></span>
                                                <input type="number" class="ays-text-input ays-text-input-90-width" id='ays_pd_container_box_shadow_y_offset' name='ays_pd_container_box_shadow_y_offset' value="<?php echo $container_box_shadow_y_offset; ?>" />
                                            </div>
                                            <div class="col-sm-3 ays_divider_left" style="display: inline-block;">
                                                <span class="ays_pd_small_hint_text"><?php echo __('Z', $this->plugin_name); ?></span>
                                                <input type="number" class="ays-text-input ays-text-input-90-width" id='ays_pd_container_box_shadow_z_offset' name='ays_pd_container_box_shadow_z_offset' value="<?php echo $container_box_shadow_z_offset; ?>" />
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- Container box-shadow end -->
                        <hr>
                        <!-- Title font size -->
                        <div class="form-group row">
                            <div class="col-sm-4">
                                <label for='ays_pd_title_font_size'>
                                    <?php echo __('Title font size',$this->plugin_name);?>
                                    <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Title font-size in pixels. It accepts only numeric values.',$this->plugin_name)?>">
                                        <i class="ays_fa_pd ays_fa-info-circle"></i>
                                    </a>
                                </label>
                            </div>
                            <div class="col-sm-8 ays_divider_left">
                                <div class="row" >
                                    <div class="col-sm-4">
                                        <label for="ays_pd_title_font_size">
                                            <?php echo __('On PC', $this->plugin_name); ?>
                                            <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Define the font size for PC devices.',$this->plugin_name)?>">
                                                <i class="ays_fa_pd ays_fa-info-circle"></i>
                                            </a>
                                        </label>
                                    </div>
                                    <div class="col-sm-4 ays_pd_display_flex_width">
                                        <div>
                                        <input type="number" id="ays_pd_title_font_size" name="ays_pd_title_font_size" value="<?php echo $title_font_size; ?>"/>
                                        </div>
                                        <div class="ays_pd_dropdown_max_width">
                                            <input type="text" value="px" class="ays-pd-form-hint-for-size" disabled="">
                                        </div>
                                    </div>
                                </div>
                                <hr>
                                <div class="row" >
                                    <div class="col-sm-4">
                                        <label for="ays_pd_title_font_size_for_mobile">
                                            <?php echo __('On Mobile', $this->plugin_name); ?>
                                            <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Define the font size for mobile devices.',$this->plugin_name)?>">
                                                <i class="ays_fa_pd ays_fa-info-circle"></i>
                                            </a>
                                        </label>
                                    </div>
                                    <div class="col-sm-4 ays_pd_display_flex_width">
                                        <div>
                                        <input type="number" id='ays_pd_title_font_size_for_mobile'name='ays_pd_title_font_size_for_mobile' 
                                        value="<?php echo $title_font_size_for_mobile; ?>" 
                                        />
                                        </div>
                                        <div class="ays_pd_dropdown_max_width">
                                            <input type="text" value="px" class="ays-pd-form-hint-for-size" disabled="">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <hr>
                        <!-- Title Shadow start-->
                        <div class="form-group row">
                            <div class="col-sm-4">
                                <label for="ays_pd_enable_title_text_shadow">
                                    <?php echo __('Title text shadow',$this->plugin_name)?>
                                    <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Specify the text shadow of the personal dictionary title.',$this->plugin_name)?>">
                                        <i class="ays_fa_pd ays_fa-info-circle"></i>
                                    </a>
                                </label>
                            </div>
                            <div class="col-sm-8 ays_divider_left">
                                <input type="checkbox" class="ays_toggle ays_toggle_slide" id="ays_pd_enable_title_text_shadow" name="ays_pd_enable_title_text_shadow" <?php echo ($enable_title_text_shadow == 'on') ? 'checked' : ''; ?>/>
                                <label for="ays_pd_enable_title_text_shadow" class="ays_switch_toggle">Toggle</label>
                                <div class="col-sm-12 ays_toggle_target ays_divider_top <?php echo ($enable_title_text_shadow == 'on') ? '' : 'display_none'; ?>" style="margin-top: 10px; padding-top: 10px;">
                                        <div class="form-group row">
                                            <div class="col-sm-12">
                                                <label for="ays_pd_title_text_shadow_color">
                                                    <?php echo __('Text shadow color',$this->plugin_name)?>
                                                    <a class="ays_help" data-toggle="tooltip" title="<?php echo __('The color of the text shadow of the title.',$this->plugin_name ); ?>">
                                                    <i class="ays_fa_pd ays_fa-info-circle"></i>
                                                    </a>
                                                </label>
                                                <input type="text" id="ays_pd_title_text_shadow_color" name="ays_pd_title_text_shadow_color" data-alpha="true" value="<?php echo $title_text_shadow_color; ?>">
                                            </div>
                                        </div>
                                    <hr>
                                    <div class="form-group row">
                                        <div class="col-sm-12">
                                            <div class="col-sm-3" style="display: inline-block;">
                                                <span class="ays_pd_small_hint_text"><?php echo __('X', $this->plugin_name); ?></span>
                                                <input type="number" class="ays-text-input ays-text-input-90-width" id='ays_pd_title_text_shadow_x_offset' name='ays_pd_title_text_shadow_x_offset' value='<?php echo $title_text_shadow_x_offset; ?>' />
                                            </div>
                                            <div class="col-sm-3 ays_divider_left" style="display: inline-block;">
                                                <span class="ays_pd_small_hint_text"><?php echo __('Y', $this->plugin_name); ?></span>
                                                <input type="number" class="ays-text-input ays-text-input-90-width" id='ays_pd_title_text_shadow_y_offset' name='ays_pd_title_text_shadow_y_offset' value="<?php echo $title_text_shadow_y_offset; ?>" />
                                            </div>
                                            <div class="col-sm-3 ays_divider_left" style="display: inline-block;">
                                                <span class="ays_pd_small_hint_text"><?php echo __('Z', $this->plugin_name); ?></span>
                                                    <input type="number" class="ays-text-input ays-text-input-90-width" id='ays_pd_title_text_shadow_z_offset' name='ays_pd_title_text_shadow_z_offset' value="<?php echo $title_text_shadow_z_offset; ?>" />
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- Title Shadow end-->
                        <hr>
                        <div class="form-group row">
                            <div class="col-sm-4">
                                <label for="ays_pd_button_text_color">
                                    <?php echo __('Buttons Text Color', $this->plugin_name); ?>
                                    <a class="ays_help" data-toggle="tooltip" data-placement="top" title="<?php echo __("On the color picker, choose the button text color of your dictionary and make it opaque if you wish. If you Clear the color, it will take the default value – white.", $this->plugin_name); ?>">
                                        <i class="ays_fa_pd ays_fa-info-circle"></i>
                                    </a>
                                </label>
                            </div>
                            <div class="col-sm-8 ays_divider_left">
                                <input type="text" id="ays_pd_button_text_color" name="ays_pd_button_text_color" data-alpha="true" value="<?php echo $button_text_color; ?>">
                            </div>
                        </div>
                        <hr>
                        <!-- Title alignment start-->
                        <div class="form-group row">
                            <div class="col-sm-4">
                                <label for='ays_pd_title_alignment'>
                                    <?= __('Title alignment', $this->plugin_name); ?>
                                    <a class="ays_help"
                                        data-toggle="tooltip"
                                        data-placement="top"
                                        title="<?= __("Specify the alignment of the title.", $this->plugin_name); ?>">
                                        <i class="ays_fa_pd ays_fa-info-circle"></i>
                                    </a>
                                </label>
                            </div>
                            <div class="col-sm-8 ays_divider_left">
                                <div class="ays_toggle_parent">
                                    <div>
                                        <div class="ays_pd_current_device_name ays_pd_current_device_name_pc_default_on ays_pd_current_device_name_pc show ays_toggle_target" style="<?php echo ($enable_pd_title_alignment_mobile) ? '' : 'display: none;' ?> text-align: center; margin-bottom: 10px; max-width: 200px;"><?php echo __('PC', $this->plugin_name) ?></div>
                                        <select name="ays_pd_title_alignment" id="ays_pd_title_alignment" class="ays-text-input ays-text-input-short">
                                            <option value="left" <?php echo ($pd_title_alignment == "left") ? "selected" : "";?>><?php echo __("Left" , $this->plugin_name); ?></option>
                                            <option value="center" <?php echo ($pd_title_alignment == "center") ? "selected" : "";?>><?php echo __("Center" , $this->plugin_name); ?></option>
                                            <option value="right" <?php echo ($pd_title_alignment == "right") ? "selected" : "";?>><?php echo __("Right" , $this->plugin_name); ?></option>
                                        </select>
                                    </div>
                                    <div class="ays_toggle_target ays_pd_title_alignment_mobile_container" style=" <?php echo ( $enable_pd_title_alignment_mobile ) ? '' : 'display:none'; ?>">
                                        <hr>
                                        <div class="ays_pd_current_device_name show" style="text-align: center; margin-bottom: 10px; max-width: 200px;"><?php echo __('Mobile', $this->plugin_name) ?></div>
                                        <select name="ays_pd_title_alignment_mobile" id="ays_pd_title_alignment_mobile" class="ays-text-input ays-text-input-short">
                                            <option value="left" <?php echo ($pd_title_alignment_mobile == "left") ? "selected" : "";?>><?php echo __("Left" , $this->plugin_name); ?></option>
                                            <option value="center" <?php echo ($pd_title_alignment_mobile == "center") ? "selected" : "";?>><?php echo __("Center" , $this->plugin_name); ?></option>
                                            <option value="right" <?php echo ($pd_title_alignment_mobile == "right") ? "selected" : "";?>><?php echo __("Right" , $this->plugin_name); ?></option>
                                        </select>
                                    </div>
                                    <div class="ays_pd_mobile_settings_container">
                                        <input type="checkbox" class="ays_toggle_mobile_checkbox" id="ays_pd_enable_title_alignment_mobile" name="ays_pd_enable_title_alignment_mobile" <?php echo $enable_pd_title_alignment_mobile ? 'checked' : '' ?>>
                                        <label for="ays_pd_enable_title_alignment_mobile" ><?php echo __('Use a different setting for Mobile', $this->plugin_name) ?></label>
                                    </div>
                                </div>
                            </div>                            
                        </div>
                        <!-- Title alignment end-->
                        <hr>
                        <!-- Description alignment start-->
                        <div class="form-group row">
                            <div class="col-sm-4">
                                <label for='ays_pd_desc_alignment'>
                                    <?= __('Description alignment', $this->plugin_name); ?>
                                    <a class="ays_help"
                                        data-toggle="tooltip"
                                        data-placement="top"
                                        title="<?= __("Specify the alignment of the description.", $this->plugin_name); ?>">
                                        <i class="ays_fa_pd ays_fa-info-circle"></i>
                                    </a>
                                </label>
                            </div>
                            <div class="col-sm-8 ays_divider_left">
                                <div class="ays_toggle_parent">
                                    <div>
                                        <div class="ays_pd_current_device_name ays_pd_current_device_name_pc_default_on ays_pd_current_device_name_pc show ays_toggle_target" style="<?php echo ($enable_pd_desc_alignment_mobile) ? '' : 'display: none;' ?> text-align: center; margin-bottom: 10px; max-width: 200px;"><?php echo __('PC', $this->plugin_name) ?></div>
                                        <select name="ays_pd_desc_alignment" id="ays_pd_desc_alignment" class="ays-text-input ays-text-input-short">
                                            <option value="left" <?php echo ($pd_desc_alignment == "left") ? "selected" : "";?>><?php echo __("Left" , $this->plugin_name); ?></option>
                                            <option value="center" <?php echo ($pd_desc_alignment == "center") ? "selected" : "";?>><?php echo __("Center" , $this->plugin_name); ?></option>
                                            <option value="right" <?php echo ($pd_desc_alignment == "right") ? "selected" : "";?>><?php echo __("Right" , $this->plugin_name); ?></option>
                                        </select>
                                    </div>
                                    <div class="ays_toggle_target ays_pd_desc_alignment_mobile_container" style=" <?php echo ( $enable_pd_desc_alignment_mobile ) ? '' : 'display:none'; ?>">
                                        <hr>
                                        <div class="ays_pd_current_device_name show" style="text-align: center; margin-bottom: 10px; max-width: 200px;"><?php echo __('Mobile', $this->plugin_name) ?></div>
                                        <select name="ays_pd_desc_alignment_mobile" id="ays_pd_desc_alignment_mobile" class="ays-text-input ays-text-input-short">
                                            <option value="left" <?php echo ($pd_desc_alignment_mobile == "left") ? "selected" : "";?>><?php echo __("Left" , $this->plugin_name); ?></option>
                                            <option value="center" <?php echo ($pd_desc_alignment_mobile == "center") ? "selected" : "";?>><?php echo __("Center" , $this->plugin_name); ?></option>
                                            <option value="right" <?php echo ($pd_desc_alignment_mobile == "right") ? "selected" : "";?>><?php echo __("Right" , $this->plugin_name); ?></option>
                                        </select>
                                    </div>
                                    <div class="ays_pd_mobile_settings_container">
                                        <input type="checkbox" class="ays_toggle_mobile_checkbox" id="ays_pd_enable_desc_alignment_mobile" name="ays_pd_enable_desc_alignment_mobile" <?php echo $enable_pd_desc_alignment_mobile ? 'checked' : '' ?>>
                                        <label for="ays_pd_enable_desc_alignment_mobile" ><?php echo __('Use a different setting for Mobile', $this->plugin_name) ?></label>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- Description alignment end-->
                        <hr>
                        <div class="form-group row">
                            <div class="col-sm-4">
                                <label for="ays_pd_description_font_size">
                                    <?php echo __('Description font size',$this->plugin_name);?>
                                    <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Description font-size in pixels. It accepts only numeric values.',$this->plugin_name)?>">
                                        <i class="ays_fa_pd ays_fa-info-circle"></i>
                                    </a>
                                </label>
                            </div>
                            <div class="col-sm-8 ays_divider_left">
                                <div class="row" >
                                    <div class="col-sm-4">
                                        <label for="ays_pd_description_font_size">
                                            <?php echo __('On PC', $this->plugin_name); ?>
                                            <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Define the font size for PC devices.',$this->plugin_name)?>">
                                                <i class="ays_fa_pd ays_fa-info-circle"></i>
                                            </a>
                                        </label>
                                    </div>
                                    <div class="col-sm-4 ays_pd_display_flex_width">
                                        <div>
                                        <input type="number" id="ays_pd_description_font_size" name="ays_pd_description_font_size" value="<?php echo $description_font_size; ?>"/>
                                        </div>
                                        <div class="ays_pd_dropdown_max_width">
                                            <input type="text" value="px" class="ays-pd-form-hint-for-size" disabled="">
                                        </div>
                                    </div>
                                </div>
                                <hr>
                                <div class="row" >
                                    <div class="col-sm-4">
                                        <label for="ays_pd_description_font_size_for_mobile">
                                            <?php echo __('On Mobile', $this->plugin_name); ?>
                                            <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Define the font size for mobile devices.',$this->plugin_name)?>">
                                                <i class="ays_fa_pd ays_fa-info-circle"></i>
                                            </a>
                                        </label>
                                    </div>
                                    <div class="col-sm-4 ays_pd_display_flex_width">
                                        <div>
                                        <input type="number" id='ays_pd_description_font_size_for_mobile'name='ays_pd_description_font_size_for_mobile'
                                        value="<?php echo $description_font_size_for_mobile; ?>" 
                                        />
                                        </div>
                                        <div class="ays_pd_dropdown_max_width">
                                            <input type="text" value="px" class="ays-pd-form-hint-for-size" disabled="">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <hr>
                        <!-- Description Shadow start-->
                        <div class="form-group row">
                            <div class="col-sm-4">
                                <label for="ays_pd_enable_description_text_shadow">
                                    <?php echo __('Description text shadow',$this->plugin_name)?>
                                    <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Specify the text shadow of the personal dictionary description.',$this->plugin_name)?>">
                                        <i class="ays_fa_pd ays_fa-info-circle"></i>
                                    </a>
                                </label>
                            </div>
                            <div class="col-sm-8 ays_divider_left">
                                <input type="checkbox" class="ays_toggle ays_toggle_slide" id="ays_pd_enable_description_text_shadow" name="ays_pd_enable_description_text_shadow" <?php echo ($enable_description_text_shadow == 'on') ? 'checked' : ''; ?>/>
                                <label for="ays_pd_enable_description_text_shadow" class="ays_switch_toggle">Toggle</label>
                                <div class="col-sm-12 ays_toggle_target ays_divider_top <?php echo ($enable_description_text_shadow == 'on') ? '' : 'display_none'; ?>" style="margin-top: 10px; padding-top: 10px;">
                                        <div class="form-group row">
                                            <div class="col-sm-12">
                                                <label for="ays_pd_description_text_shadow_color">
                                                    <?php echo __('Text shadow color',$this->plugin_name)?>
                                                    <a class="ays_help" data-toggle="tooltip" title="<?php echo __('The color of the text shadow of the description.',$this->plugin_name ); ?>">
                                                    <i class="ays_fa_pd ays_fa-info-circle"></i>
                                                    </a>
                                                </label>
                                                <input type="text" id="ays_pd_description_text_shadow_color" name="ays_pd_description_text_shadow_color" data-alpha="true" value="<?php echo $description_text_shadow_color; ?>">
                                            </div>
                                        </div>
                                    <hr>
                                    <div class="form-group row">
                                        <div class="col-sm-12">
                                            <div class="col-sm-3" style="display: inline-block;">
                                                <span class="ays_pd_small_hint_text"><?php echo __('X', $this->plugin_name); ?></span>
                                                <input type="number" class="ays-text-input ays-text-input-90-width" id='ays_pd_description_text_shadow_x_offset' name='ays_pd_description_text_shadow_x_offset' value='<?php echo $description_text_shadow_x_offset; ?>' />
                                            </div>
                                            <div class="col-sm-3 ays_divider_left" style="display: inline-block;">
                                                <span class="ays_pd_small_hint_text"><?php echo __('Y', $this->plugin_name); ?></span>
                                                <input type="number" class="ays-text-input ays-text-input-90-width" id='ays_pd_description_text_shadow_y_offset' name='ays_pd_description_text_shadow_y_offset' value="<?php echo $description_text_shadow_y_offset; ?>" />
                                            </div>
                                            <div class="col-sm-3 ays_divider_left" style="display: inline-block;">
                                                <span class="ays_pd_small_hint_text"><?php echo __('Z', $this->plugin_name); ?></span>
                                                    <input type="number" class="ays-text-input ays-text-input-90-width" id='ays_pd_description_text_shadow_z_offset' name='ays_pd_description_text_shadow_z_offset' value="<?php echo $description_text_shadow_z_offset; ?>" />
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div><!-- Description Shadow end-->
                    </diV>
                </div>
                <div class="ays-pd-accordion-options-main-container" data-collapsed="false">
                    <div class="ays-pd-accordion-container">
                        <?php echo $pd_accordion_svg_html; ?>
                        <p class="ays-pd-subtitle"><?php echo __("Menu Styles" , $this->plugin_name)?></p>
                    </div>
                    <hr class="ays-pd-bolder-hr"/>
                    <div class="ays-pd-accordion-options-box">
                        <!-- Menu styles start -->
                        <!-- Menu Items start -->
                        <div class="form-group row">
                            <div class="col-sm-4">
                                <label for='ays_pd_menu_items'>
                                    <?php echo __('Menu Items', $this->plugin_name); ?>
                                    <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Choose how the menu items will be displayed.',$this->plugin_name)?>">
                                        <i class="ays_fa_pd ays_fa-info-circle"></i>
                                    </a>
                                </label>
                            </div>
                            <div class="col-sm-8 ays_divider_left">
                                <div class="ays_toggle_parent">
                                    <div>
                                        <div class="ays_pd_current_device_name ays_pd_current_device_name_pc_default_on ays_pd_current_device_name_pc show ays_toggle_target" style="<?php echo ($enable_menu_items_mobile) ? '' : 'display: none;' ?> text-align: center; margin-bottom: 10px; max-width: 200px;"><?php echo __('PC', $this->plugin_name) ?></div>
                                        <select name="ays_pd_menu_items" id="ays_pd_menu_items" class="ays-text-input ays-text-input-short">
                                            <option value="text" <?= $menu_items == "text" ? 'selected' : ''; ?>>
                                                <?= __("Text", $this->plugin_name); ?>
                                            </option>
                                            <option value="icon" <?= $menu_items == "icon" ? 'selected' : ''; ?>>
                                                <?= __("Icon", $this->plugin_name); ?>
                                            </option>
                                            <option value="text-icon" <?= $menu_items == "text-icon" ? 'selected' : ''; ?>>
                                                <?= __("Text & Icon", $this->plugin_name); ?>
                                            </option>
                                        </select>
                                    </div>
                                    <div class="ays_toggle_target ays_pd_menu_items_mobile_container" style=" <?php echo ( $enable_menu_items_mobile ) ? '' : 'display:none'; ?>">
                                        <hr>
                                        <div class="ays_pd_current_device_name show" style="text-align: center; margin-bottom: 10px; max-width: 200px;"><?php echo __('Mobile', $this->plugin_name) ?></div>
                                        <select name="ays_pd_menu_items_mobile" id="ays_pd_menu_items_mobile" class="ays-text-input ays-text-input-short">
                                            <option value="text" <?= $menu_items_mobile == "text" ? 'selected' : ''; ?>>
                                                <?= __("Text", $this->plugin_name); ?>
                                            </option>
                                            <option value="icon" <?= $menu_items_mobile == "icon" ? 'selected' : ''; ?>>
                                                <?= __("Icon", $this->plugin_name); ?>
                                            </option>
                                            <option value="text-icon" <?= $menu_items_mobile == "text-icon" ? 'selected' : ''; ?>>
                                                <?= __("Text & Icon", $this->plugin_name); ?>
                                            </option>
                                        </select>
                                    </div>
                                    <div class="ays_pd_mobile_settings_container">
                                        <input type="checkbox" class="ays_toggle_mobile_checkbox" id="ays_pd_enable_menu_items_mobile" name="ays_pd_enable_menu_items_mobile" <?php echo $enable_menu_items_mobile ? 'checked' : '' ?>>
                                        <label for="ays_pd_enable_menu_items_mobile" ><?php echo __('Use a different setting for Mobile', $this->plugin_name) ?></label>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- Menu Items end -->
                        <hr/>
                        <!-- Menu Position Start -->
                        <div class="form-group row">
                            <div class="col-sm-4">
                                <label for='ays_pd_menu_position'>
                                    <?php echo __('Menu Position', $this->plugin_name); ?>
                                    <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Choose where to display the Dictionary Menu. You can display the menu either on the left side or at the top of the Dictionary Container.',$this->plugin_name)?>">
                                        <i class="ays_fa_pd ays_fa-info-circle"></i>
                                    </a>
                                </label>
                            </div>
                            <div class="col-sm-8 ays_divider_left">
                                <div class="ays_toggle_parent">
                                    <div>
                                        <div class="ays_pd_current_device_name ays_pd_current_device_name_pc_default_on ays_pd_current_device_name_pc show ays_toggle_target" style="<?php echo ($enable_menu_position_mobile) ? '' : 'display: none;' ?> text-align: center; margin-bottom: 10px; max-width: 200px;"><?php echo __('PC', $this->plugin_name) ?></div>
                                        <select name="ays_pd_menu_position" id="ays_pd_menu_position" class="ays-text-input ays-text-input-short">
                                            <option value="top" <?= $menu_position == "top" ? 'selected' : ''; ?>>
                                                <?= __("Top", $this->plugin_name); ?>
                                            </option>
                                            <option value="left" <?= $menu_position == "left" ? 'selected' : ''; ?>>
                                                <?= __("Left", $this->plugin_name); ?>
                                            </option>
                                        </select>
                                    </div>
                                    <div class="ays_toggle_target ays_pd_menu_position_mobile_container" style=" <?php echo ( $enable_menu_position_mobile ) ? '' : 'display:none'; ?>">
                                        <hr>
                                        <div class="ays_pd_current_device_name show" style="text-align: center; margin-bottom: 10px; max-width: 200px;"><?php echo __('Mobile', $this->plugin_name) ?></div>
                                        <select name="ays_pd_menu_position_mobile" id="ays_pd_menu_position_mobile" class="ays-text-input ays-text-input-short">
                                            <option value="top" <?= $menu_position_mobile == "top" ? 'selected' : ''; ?>>
                                                <?= __("Top", $this->plugin_name); ?>
                                            </option>
                                            <option value="left" <?= $menu_position_mobile == "left" ? 'selected' : ''; ?>>
                                                <?= __("Left", $this->plugin_name); ?>
                                            </option>
                                        </select>
                                    </div>
                                    <div class="ays_pd_mobile_settings_container">
                                        <input type="checkbox" class="ays_toggle_mobile_checkbox" id="ays_pd_enable_menu_position_mobile" name="ays_pd_enable_menu_position_mobile" <?php echo $enable_menu_position_mobile ? 'checked' : '' ?>>
                                        <label for="ays_pd_enable_menu_position_mobile" ><?php echo __('Use a different setting for Mobile', $this->plugin_name) ?></label>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- Menu Position End -->
                        <hr/>
                        <!-- Menu Layout Start -->
                        <div class="form-group row">
                            <div class="col-sm-4">
                                <label for='ays_pd_menu_layout'>
                                    <?php echo __('Menu Layout', $this->plugin_name); ?>
                                    <a class="ays_help" data-toggle="tooltip" data-html="true" 
                                    title="<?php
                                        echo htmlspecialchars(__('Choose the layout of the menu items.',$this->plugin_name) . '
                                        <ul class="ays_help_ul" style="list-style-type: circle;padding-left: 20px;">
                                            <li>
                                                <strong>
                                                ' .__('List',$this->plugin_name) . '
                                                </strong> :
                                                ' .__('The menu items will be displayed one below the other.',$this->plugin_name) . '
                                            </li>
                                            <li>
                                                <strong>
                                                ' .__('Grid',$this->plugin_name) . '
                                                </strong> :
                                                ' .__('The menu items will be displayed next to each other.',$this->plugin_name) . '
                                            </li>
                                        </ul>
                                        <br>
                                        <strong>
                                        ' .__('*Note',$this->plugin_name) . '
                                        </strong>:
                                        ' .__('The Layout will work for the menu items only if the menu position is set to Top.',$this->plugin_name)
                                        );
                                    ?>">
                                        <i class="ays_fa_pd ays_fa-info-circle"></i>
                                    </a>
                                </label>
                            </div>
                            <div class="col-sm-8 ays_divider_left">
                                <div class="ays_toggle_parent">
                                    <div>
                                        <div class="ays_pd_current_device_name ays_pd_current_device_name_pc show ays_toggle_target" style="<?php echo ($enable_menu_layout_mobile) ? '' : 'display: none;' ?> text-align: center; margin-bottom: 10px; max-width: 200px;"><?php echo __('PC', $this->plugin_name) ?></div>
                                        <select name="ays_pd_menu_layout" id="ays_pd_menu_layout" class="ays-text-input ays-text-input-short" <?php echo ($menu_position == 'left') ? 'disabled' : '' ?>>
                                            <option value="grid" <?= $menu_layout == "grid" ? 'selected' : ''; ?>>
                                                <?= __("Grid", $this->plugin_name); ?>
                                            </option>
                                            <option value="list" <?= $menu_layout == "list" ? 'selected' : ''; ?>>
                                                <?= __("List", $this->plugin_name); ?>
                                            </option>
                                        </select>
                                    </div>
                                    <div class="ays_toggle_target ays_pd_menu_layout_mobile_container" style=" <?php echo ( $enable_menu_layout_mobile ) ? '' : 'display:none'; ?>">
                                        <hr>
                                        <div class="ays_pd_current_device_name show" style="text-align: center; margin-bottom: 10px; max-width: 200px;"><?php echo __('Mobile', $this->plugin_name) ?></div>
                                        <select name="ays_pd_menu_layout_mobile" id="ays_pd_menu_layout_mobile" class="ays-text-input ays-text-input-short" <?php echo ($menu_position_mobile == 'left') ? 'disabled' : '' ?>>
                                            <option value="grid" <?= $menu_layout_mobile == "grid" ? 'selected' : ''; ?>>
                                                <?= __("Grid", $this->plugin_name); ?>
                                            </option>
                                            <option value="list" <?= $menu_layout_mobile == "list" ? 'selected' : ''; ?>>
                                                <?= __("List", $this->plugin_name); ?>
                                            </option>
                                        </select>
                                    </div>
                                    <div class="ays_pd_mobile_settings_container">
                                        <input type="checkbox" class="ays_toggle_mobile_checkbox" id="ays_pd_enable_menu_layout_mobile" name="ays_pd_enable_menu_layout_mobile" <?php echo $enable_menu_layout_mobile ? 'checked' : '' ?>>
                                        <label for="ays_pd_enable_menu_layout_mobile" ><?php echo __('Use a different setting for Mobile', $this->plugin_name) ?></label>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- Menu Layout End -->
                        <hr/>
                        <!-- Menu styles end -->
                    </div>
                </div>
                <div class="ays-pd-accordion-options-main-container" data-collapsed="false">
                    <div class="ays-pd-accordion-container">
                        <?php echo $pd_accordion_svg_html; ?>
                        <p class="ays-pd-subtitle"><?php echo __("Answer Styles" , $this->plugin_name)?></p>
                    </div>
                    <hr class="ays-pd-bolder-hr"/>
                    <div class="ays-pd-accordion-options-box">
                        <!-- Title alignment start-->
                        <div class="form-group row">
                            <div class="col-sm-4">
                                <label for='ays_pd_answer_view'>
                                    <?= __('Answer view', $this->plugin_name); ?>
                                    <a class="ays_help"
                                        data-toggle="tooltip"
                                        data-placement="top"
                                        title="<?= __("Arrange the answers by the following layouts.", $this->plugin_name); ?>">
                                        <i class="ays_fa_pd ays_fa-info-circle"></i>
                                    </a>
                                </label>
                            </div>
                            <div class="col-sm-8 ays_divider_left">
                                <div class="ays_toggle_parent">
                                    <div>
                                        <div class="ays_pd_current_device_name ays_pd_current_device_name_pc_default_on ays_pd_current_device_name_pc show ays_toggle_target" style="<?php echo ($enable_pd_answer_view_mobile) ? '' : 'display: none;' ?> text-align: center; margin-bottom: 10px; max-width: 200px;"><?php echo __('PC', $this->plugin_name) ?></div>
                                        <select id="ays_pd_answer_view" name="ays_pd_answer_view" class="ays-text-input ays-text-input-short">
                                            <option value="grid" <?php echo ($pd_answer_view == "grid") ? "selected" : "";?>><?php echo __("Grid" , $this->plugin_name); ?></option>
                                            <option value="list" <?php echo ($pd_answer_view == "list") ? "selected" : "";?>><?php echo __("List" , $this->plugin_name); ?></option>                           
                                        </select>
                                    </div>
                                    <div class="ays_toggle_target ays_pd_answer_view_mobile_container" style=" <?php echo ( $enable_pd_answer_view_mobile ) ? '' : 'display:none'; ?>">
                                        <hr>
                                        <div class="ays_pd_current_device_name show" style="text-align: center; margin-bottom: 10px; max-width: 200px;"><?php echo __('Mobile', $this->plugin_name) ?></div>
                                        <select id="ays_pd_answer_view_mobile" name="ays_pd_answer_view_mobile" class="ays-text-input ays-text-input-short">
                                            <option value="grid" <?php echo ($pd_answer_view_mobile == "grid") ? "selected" : "";?>><?php echo __("Grid" , $this->plugin_name); ?></option>
                                            <option value="list" <?php echo ($pd_answer_view_mobile == "list") ? "selected" : "";?>><?php echo __("List" , $this->plugin_name); ?></option>
                                        </select>
                                    </div>
                                    <div class="ays_pd_mobile_settings_container">
                                        <input type="checkbox" class="ays_toggle_mobile_checkbox" id="ays_pd_enable_answer_view_mobile" name="ays_pd_enable_answer_view_mobile" <?php echo $enable_pd_answer_view_mobile ? 'checked' : '' ?>>
                                        <label for="ays_pd_enable_answer_view_mobile" ><?php echo __('Use a different setting for Mobile', $this->plugin_name) ?></label>
                                    </div>
                                </div>     
                            </div>
                        </div>
                        <!-- Title alignment end-->
                        <hr/>
                        <div class="form-group row">
                            <div class="col-sm-4">
                                <label for="ays_pd_enable_answer_border">
                                    <?php echo __('Answer border',$this->plugin_name)?>
                                    <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Allow answer border.',$this->plugin_name)?>">
                                        <i class="ays_fa_pd ays_fa-info-circle"></i>
                                    </a>
                                </label>
                            </div>
                            <div class="col-sm-8 ays_divider_left">
                                <input type="checkbox" class="ays_toggle ays_toggle_slide" id="ays_pd_enable_answer_border" name="ays_pd_enable_answer_border" <?php echo ($ays_pd_enable_answer_border == 'on') ? 'checked' : ''; ?>/>
                                <label for="ays_pd_enable_answer_border" class="ays_switch_toggle">Toggle</label>
                                <div class="ays_toggle_target ays_divider_top <?php echo ($ays_pd_enable_answer_border == 'on') ? '' : 'display_none'; ?>" style="margin-top: 10px; padding-top: 10px;">
                                    <div class="form-group row">
                                        <div class="col-sm-4">
                                            <label for="ays_pd_answer_border_width">
                                                <?php echo __('Answer border width',$this->plugin_name)?>
                                                <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Dictionary answer border width in pixels. It accepts only numeric values.',$this->plugin_name)?>">
                                                    <i class="ays_fa_pd ays_fa-info-circle"></i>
                                                </a>
                                            </label>
                                        </div>
                                        <div class="col-sm-8 ays_divider_left">
                                            <div class="ays_toggle_parent">
                                                <div>
                                                    <div class="ays_pd_current_device_name ays_pd_current_device_name_pc_default_on ays_pd_current_device_name_pc show ays_toggle_target" style="<?php echo ($enable_answer_border_width_mobile) ? '' : 'display: none;' ?> text-align: center; margin-bottom: 10px; max-width: 200px;">
                                                        <?php echo __('PC', $this->plugin_name) ?>
                                                    </div>
                                                    <div class="ays_divider_left ays_pd_display_flex_width">
                                                        <div>
                                                        <input type="number" id="ays_pd_answer_border_width" name="ays_pd_answer_border_width" value="<?php echo $answer_border_width; ?>"/>
                                                        </div>
                                                        <div class="ays_pd_dropdown_max_width">
                                                            <input type="text" value="px" class="ays-pd-form-hint-for-size" disabled="">
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="ays_toggle_target ays_pd_answer_border_width_mobile_container" style=" <?php echo ( $enable_answer_border_width_mobile ) ? '' : 'display:none'; ?>">
                                                    <hr>
                                                    <div class="ays_pd_current_device_name show" style="text-align: center; margin-bottom: 10px; max-width: 200px;">
                                                        <?php echo __('Mobile', $this->plugin_name) ?>
                                                    </div>
                                                    <div class="ays_divider_left ays_pd_display_flex_width">
                                                        <div>
                                                        <input type="number" id="ays_pd_answer_border_width_mobile" name="ays_pd_answer_border_width_mobile" value="<?php echo $answer_border_width_mobile; ?>"/>
                                                        </div>
                                                        <div class="ays_pd_dropdown_max_width">
                                                            <input type="text" value="px" class="ays-pd-form-hint-for-size" disabled="">
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="ays_pd_mobile_settings_container">
                                                    <input type="checkbox" class="ays_toggle_mobile_checkbox" id="ays_pd_enable_answer_border_width_mobile" name="ays_pd_enable_answer_border_width_mobile" <?php echo $enable_answer_border_width_mobile ? 'checked' : '' ?>>
                                                    <label for="ays_pd_enable_answer_border_width_mobile" ><?php echo __('Use a different setting for Mobile', $this->plugin_name) ?></label>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <hr>
                                    <div class="form-group row">
                                        <div class="col-sm-4">
                                            <label for="ays_pd_answer_border_color">
                                                <?php echo __('Answer border color', $this->plugin_name); ?>
                                                <a class="ays_help" data-toggle="tooltip" data-placement="top" title="<?php echo __("On the color picker, choose the answer border color of your dictionary and make it opaque if you wish. If you Clear the color, it will take the default value - Silver.", $this->plugin_name); ?>">
                                                    <i class="ays_fa_pd ays_fa-info-circle"></i>
                                                </a>
                                            </label>
                                        </div>
                                        <div class="col-sm-8 ays_divider_left">
                                            <input type="text" id="ays_pd_answer_border_color" name="ays_pd_answer_border_color" data-alpha="true" value="<?php echo $answer_border_color; ?>">
                                        </div>
                                    </div>
                                    <hr>
                                    <!-- Answer Border style -->
                                    <div class="form-group row">
                                        <div class="col-sm-4">
                                            <label for="ays_pd_answer_border_style">
                                                <?php echo __('Answer border style',$this->plugin_name)?>
                                                <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Choose your preferred style of the border.',$this->plugin_name)?>">
                                                    <i class="ays_fa_pd ays_fa-info-circle"></i>
                                                </a>
                                            </label>
                                        </div>
                                        <div class="col-sm-8 ays_divider_left">
                                            <select name="ays_pd_answer_border_style" id="ays_pd_answer_border_style" class="ays-text-input ays-text-input-short">
                                                <option value="solid" <?= $answer_border_style == "solid" ? 'selected' : ''; ?>>
                                                    <?= __("Solid", $this->plugin_name); ?>
                                                </option>
                                                <option value="dashed" <?= $answer_border_style == "dashed" ? 'selected' : ''; ?>>
                                                    <?= __("Dashed", $this->plugin_name); ?>
                                                </option>
                                                <option value="dotted" <?= $answer_border_style == "dotted" ? 'selected' : ''; ?>>
                                                    <?= __("Dotted", $this->plugin_name); ?>
                                                </option>
                                                <option value="double" <?= $answer_border_style == "double" ? 'selected' : ''; ?>>
                                                    <?= __("Double", $this->plugin_name); ?>
                                                </option>
                                                <option value="groove" <?= $answer_border_style == "groove" ? 'selected' : ''; ?>>
                                                    <?= __("Groove", $this->plugin_name); ?>
                                                </option>
                                                <option value="ridge" <?= $answer_border_style == "ridge" ? 'selected' : ''; ?>>
                                                    <?= __("Ridge", $this->plugin_name); ?>
                                                </option>
                                                <option value="inset" <?= $answer_border_style == "inset" ? 'selected' : ''; ?>>
                                                    <?= __("Inset", $this->plugin_name); ?>
                                                </option>
                                                <option value="outset" <?= $answer_border_style == "outset" ? 'selected' : ''; ?>>
                                                    <?= __("Outset", $this->plugin_name); ?>
                                                </option>
                                                <option value="none" <?= $answer_border_style == "none" ? 'selected' : ''; ?>>
                                                    <?= __("None", $this->plugin_name); ?>
                                                </option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <hr/>
                        <div class="form-group row">
                            <div class="col-sm-4">
                                <label for='ays_pd_answer_font_size'>
                                    <?php echo __('Answer font size', $this->plugin_name); ?>
                                    <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Define the font size of the answers in your game. The field accepts only numeric values.',$this->plugin_name)?>">
                                        <i class="ays_fa_pd ays_fa-info-circle"></i>
                                    </a>
                                </label>
                            </div>
                            <div class="col-sm-8 ays_divider_left">
                                <div class="row" >
                                    <div class="col-sm-4">
                                        <label for="ays_pd_answer_font_size">
                                            <?php echo __('On PC', $this->plugin_name); ?>
                                            <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Define the font size for PC devices.',$this->plugin_name)?>">
                                                <i class="ays_fa_pd ays_fa-info-circle"></i>
                                            </a>
                                        </label>
                                    </div>                            
                                    <div class="col-sm-4 ays_pd_display_flex_width">
                                        <div>
                                        <input type="number" id='ays_pd_answer_font_size'name='ays_pd_answer_font_size' value="<?php echo $answer_font_size; ?>"/>
                                        </div>
                                        <div class="ays_pd_dropdown_max_width">
                                            <input type="text" value="px" class="ays-pd-form-hint-for-size" disabled="">
                                        </div>
                                    </div>
                                </div>
                                <hr>
                                <div class="row" >
                                    <div class="col-sm-4">
                                        <label for="ays_pd_answer_font_size_for_mobile">
                                            <?php echo __('On Mobile', $this->plugin_name); ?>
                                            <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Define the font size for mobile devices.',$this->plugin_name)?>">
                                                <i class="ays_fa_pd ays_fa-info-circle"></i>
                                            </a>
                                        </label>
                                    </div>
                                    <div class="col-sm-4 ays_pd_display_flex_width">
                                        <div>
                                        <input type="number" id='ays_pd_answer_font_size_for_mobile'name='ays_pd_answer_font_size_for_mobile' value="<?php echo $answer_font_size_for_mobile; ?>"/>
                                        </div>
                                        <div class="ays_pd_dropdown_max_width">
                                            <input type="text" value="px" class="ays-pd-form-hint-for-size" disabled="">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <hr>
                        <div class="form-group row">
                            <div class="col-sm-4">
                                <label for="ays_pd_answer_bg_color">
                                    <?php echo __('Answer Background color', $this->plugin_name); ?>
                                    <a class="ays_help" data-toggle="tooltip" data-placement="top" title="<?php echo __("On the color picker, choose the answer border color of your dictionary and make it opaque if you wish. If you Clear the color, it will take the default value – White.", $this->plugin_name); ?>">
                                        <i class="ays_fa_pd ays_fa-info-circle"></i>
                                    </a>
                                </label>
                            </div>
                            <div class="col-sm-8 ays_divider_left">
                                <input type="text" id="ays_pd_answer_bg_color" name="ays_pd_answer_bg_color" data-alpha="true" value="<?php echo $answer_bg_color; ?>">
                            </div>
                        </div>
                        <hr>
                        <!-- Answer box-shadow start -->
                        <div class="form-group row">
                            <div class="col-sm-4">
                                <label for="ays_pd_enable_answer_box_shadow">
                                    <?php echo __('Answer box shadow',$this->plugin_name)?>
                                    <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Specify the box shadow of the personal dictionary answer.',$this->plugin_name)?>">
                                        <i class="ays_fa_pd ays_fa-info-circle"></i>
                                    </a>
                                </label>
                            </div>
                            <div class="col-sm-8 ays_divider_left">
                                <input type="checkbox" class="ays_toggle ays_toggle_slide" id="ays_pd_enable_answer_box_shadow" name="ays_pd_enable_answer_box_shadow" <?php echo ($enable_answer_box_shadow == 'on') ? 'checked' : ''; ?>/>
                                <label for="ays_pd_enable_answer_box_shadow" class="ays_switch_toggle">Toggle</label>
                                <div class="col-sm-12 ays_toggle_target ays_divider_top <?php echo ($enable_answer_box_shadow == 'on') ? '' : 'display_none'; ?>" style="margin-top: 10px; padding-top: 10px;">
                                    <div class="form-group row">
                                        <div class="col-sm-12">
                                            <label for="ays_pd_answer_box_shadow_color">
                                                <?php echo __('Box shadow color',$this->plugin_name)?>
                                                <a class="ays_help" data-toggle="tooltip" title="<?php echo __('The color of the box shadow of the answer.',$this->plugin_name ); ?>">
                                                <i class="ays_fa_pd ays_fa-info-circle"></i>
                                                </a>
                                            </label>
                                            <input type="text" id="ays_pd_answer_box_shadow_color" name="ays_pd_answer_box_shadow_color" data-alpha="true" value="<?php echo $answer_box_shadow_color; ?>">
                                        </div>
                                    </div>
                                    <hr>
                                    <div class="form-group row">
                                        <div class="col-sm-12">
                                            <div class="col-sm-3" style="display: inline-block;">
                                                <span class="ays_pd_small_hint_text"><?php echo __('X', $this->plugin_name); ?></span>
                                                <input type="number" class="ays-text-input ays-text-input-90-width" id='ays_pd_answer_box_shadow_x_offset' name='ays_pd_answer_box_shadow_x_offset' value='<?php echo $answer_box_shadow_x_offset; ?>' />
                                            </div>
                                            <div class="col-sm-3 ays_divider_left" style="display: inline-block;">
                                                <span class="ays_pd_small_hint_text"><?php echo __('Y', $this->plugin_name); ?></span>
                                                <input type="number" class="ays-text-input ays-text-input-90-width" id='ays_pd_answer_box_shadow_y_offset' name='ays_pd_answer_box_shadow_y_offset' value="<?php echo $answer_box_shadow_y_offset; ?>" />
                                            </div>
                                            <div class="col-sm-3 ays_divider_left" style="display: inline-block;">
                                                <span class="ays_pd_small_hint_text"><?php echo __('Z', $this->plugin_name); ?></span>
                                                <input type="number" class="ays-text-input ays-text-input-90-width" id='ays_pd_answer_box_shadow_z_offset' name='ays_pd_answer_box_shadow_z_offset' value="<?php echo $answer_box_shadow_z_offset; ?>" />
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- Answer box-shadow end -->
                    </div>
                </div>
                <div class="ays-pd-accordion-options-main-container" data-collapsed="false">
                    <div class="ays-pd-accordion-container">
                        <?php echo $pd_accordion_svg_html; ?>
                        <p class="ays-pd-subtitle"><?php echo __("Button Styles" , $this->plugin_name)?></p>
                    </div>
                    <hr class="ays-pd-bolder-hr"/>
                    <div class="ays-pd-accordion-options-box">
                        <div class="form-group row">
                            <div class="col-sm-4">
                                <label for='ays_pd_buttons_font_size'>
                                    <?php echo __('Button font size',$this->plugin_name);?>
                                    <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Button font-size in pixels. It accepts only numeric values.',$this->plugin_name)?>">
                                        <i class="ays_fa_pd ays_fa-info-circle"></i>
                                    </a>
                                </label>
                            </div>
                            <div class="col-sm-8 ays_divider_left">
                                <div class="row" >
                                    <div class="col-sm-4">
                                        <label for="ays_pd_buttons_font_size">
                                            <?php echo __('On PC', $this->plugin_name); ?>
                                            <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Define the button font size for PC devices.',$this->plugin_name)?>">
                                                <i class="ays_fa_pd ays_fa-info-circle"></i>
                                            </a>
                                        </label>
                                    </div>
                                    <div class="col-sm-4 ays_pd_display_flex_width">
                                        <div>
                                        <input type="number" id='ays_pd_buttons_font_size'name='ays_pd_buttons_font_size' value="<?php echo $button_font_size; ?>"/>
                                        </div>
                                        <div class="ays_pd_dropdown_max_width">
                                            <input type="text" value="px" class="ays-pd-form-hint-for-size" disabled="">
                                        </div>
                                    </div>
                                </div>
                                <hr>
                                <div class="row" >
                                    <div class="col-sm-4">
                                        <label for="ays_pd_buttons_font_size_for_mobile">
                                            <?php echo __('On Mobile', $this->plugin_name); ?>
                                            <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Define the button font size for mobile devices.',$this->plugin_name)?>">
                                                <i class="ays_fa_pd ays_fa-info-circle"></i>
                                            </a>
                                        </label>
                                    </div>
                                    <div class="col-sm-4 ays_pd_display_flex_width">
                                        <div>
                                        <input type="number" id='ays_pd_buttons_font_size_for_mobile' name='ays_pd_buttons_font_size_for_mobile' 
                                        value="<?php echo $button_font_size_for_mobile; ?>" 
                                        />
                                        </div>
                                        <div class="ays_pd_dropdown_max_width">
                                            <input type="text" value="px" class="ays-pd-form-hint-for-size" disabled="">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div> <!-- Buttons font size -->
                        <hr>
                        <div class="form-group row">
                            <div class="col-sm-4">
                                <label for="ays_pd_buttons_left_right_padding">
                                    <?php echo __('Buttons padding',$this->plugin_name)?>
                                    <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Padding of buttons.',$this->plugin_name)?>">
                                        <i class="ays_fa_pd ays_fa-info-circle"></i>
                                    </a>
                                </label>
                            </div>
                            <div class="col-sm-8 ays_divider_left">
                            <div class="form-group row">
                                    <div class="col-sm-4">                            
                                        <div>
                                            <span class="ays_pd_small_hint_text"><?php echo __('Left / Right',$this->plugin_name)?></span>
                                        </div>
                                        <div class="ays_pd_display_flex_width">
                                            <div>
                                            <input type="number" class="ays-text-input" id='ays_pd_buttons_left_right_padding' name='ays_pd_buttons_left_right_padding' value="<?php echo $buttons_left_right_padding; ?>" style="width: 100px;" />
                                            </div>
                                            <div class="ays_pd_dropdown_max_width">
                                                <input type="text" value="px" class="ays-pd-form-hint-for-size" disabled="">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-sm-4 ays_divider_left">
                                        <div>
                                            <span class="ays_pd_small_hint_text"><?php echo __('Top / Bottom',$this->plugin_name)?></span>
                                        </div>
                                        <div class="ays_pd_display_flex_width">
                                            <div>
                                            <input type="number" class="ays-text-input" id='ays_pd_buttons_top_bottom_padding' name='ays_pd_buttons_top_bottom_padding' value="<?php echo $buttons_top_bottom_padding; ?>" style="width: 100px;" />
                                            </div>
                                            <div class="ays_pd_dropdown_max_width">
                                                <input type="text" value="px" class="ays-pd-form-hint-for-size" disabled="">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div> <!-- Buttons padding -->
                        <hr/>
                        <div class="form-group row">
                            <div class="col-sm-4">
                                <label for="ays_pd_buttons_border_radius">
                                    <?php echo __('Buttons border-radius',$this->plugin_name)?>
                                    <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Dictionary buttons border-radius in pixels. It accepts only numeric values.',$this->plugin_name)?>">
                                        <i class="ays_fa_pd ays_fa-info-circle"></i>
                                    </a>
                                </label>
                            </div>
                            <div class="col-sm-8 ays_divider_left ays_pd_display_flex_width">
                                <div>
                                <input type="number" id="ays_pd_buttons_border_radius" name="ays_pd_buttons_border_radius" value="<?php echo $buttons_border_radius; ?>"/>
                                </div>
                                <div class="ays_pd_dropdown_max_width">
                                    <input type="text" value="px" class="ays-pd-form-hint-for-size" disabled="">
                                </div>
                            </div>
                        </div> <!-- Buttons border radius -->
                        <hr/>
                        <div class="form-group row">
                            <div class="col-sm-4">
                                <label for='ays_pd_question_font_size'>
                                    <?php echo __('Question font size', $this->plugin_name); ?>
                                    <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Define the font size of the questions in your game. The field accepts only numeric values.',$this->plugin_name)?>">
                                        <i class="ays_fa_pd ays_fa-info-circle"></i>
                                    </a>
                                </label>
                            </div>
                            <div class="col-sm-8 ays_divider_left">
                                <div class="row" >
                                    <div class="col-sm-4">
                                        <label for="ays_pd_question_font_size">
                                            <?php echo __('On PC', $this->plugin_name); ?>
                                            <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Define the font size for PC devices.',$this->plugin_name)?>">
                                                <i class="ays_fa_pd ays_fa-info-circle"></i>
                                            </a>
                                        </label>
                                    </div>
                                    <div class="col-sm-4 ays_pd_display_flex_width">
                                        <div>
                                        <input type="number" id='ays_pd_question_font_size'name='ays_pd_question_font_size' value="<?php echo $question_font_size; ?>"/>
                                        </div>
                                        <div class="ays_pd_dropdown_max_width">
                                            <input type="text" value="px" class="ays-pd-form-hint-for-size" disabled="">
                                        </div>
                                    </div>
                                </div>
                                <hr>
                                <div class="row" >
                                    <div class="col-sm-4">
                                        <label for="ays_pd_question_font_size_for_mobile">
                                            <?php echo __('On Mobile', $this->plugin_name); ?>
                                            <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Define the font size for mobile devices.',$this->plugin_name)?>">
                                                <i class="ays_fa_pd ays_fa-info-circle"></i>
                                            </a>
                                        </label>
                                    </div>
                                    <div class="col-sm-4 ays_pd_display_flex_width">
                                        <div>
                                        <input type="number" id='ays_pd_question_font_size_for_mobile'name='ays_pd_question_font_size_for_mobile' value="<?php echo $question_font_size_for_mobile; ?>"/>
                                        </div>
                                        <div class="ays_pd_dropdown_max_width">
                                            <input type="text" value="px" class="ays-pd-form-hint-for-size" disabled="">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- STYLES -->
                    </div>
                </div>
                <div class="ays-pd-accordion-options-main-container" data-collapsed="false">
                    <div class="ays-pd-accordion-container">
                        <!--Translations-->
                        <?php echo $pd_accordion_svg_html; ?>
                        <p class="ays-pd-subtitle"><?php echo __("Translations" , $this->plugin_name)?></p>
                    </div>
                    <hr class="ays-pd-bolder-hr"/>
                    <div class="ays-pd-accordion-options-box">
                        <blockquote class="ays_warning">
                            <p style="margin-bottom:0px; font-size:14px;"><?php echo __( "If you make a change here, these words will not be translatable via translation tools!", $this->plugin_name ); ?></p>
                        </blockquote>
                        <div class="form-group row">
                            <div class="col-sm-4">
                                <label for="ays_pd_change_names">
                                    <?php echo __('Write custom texts for phrases',$this->plugin_name)?>
                                    <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Write your desired custom texts for the phrases, instead of the default ones. The changed texts will be displayed on the front end.',$this->plugin_name)?>">
                                        <i class="ays_fa_pd ays_fa-info-circle"></i>
                                    </a>
                                </label>
                            </div>
                            <div class="col-sm-8 ays_divider_left ays_toggle_parent">
                                <div>
                                    <input type="text" class="ays-enable-timer1" name="ays_pd_change_group_name" id="ays_pd_change_group_name" value="<?php echo $change_group_name; ?>">
                                </div>
                                <hr>
                                <div>
                                    <input type="text" class="ays-enable-timer1" name="ays_pd_change_word_name" id="ays_pd_change_word_name" value="<?php echo $change_word_name ?>">
                                </div>
                                <hr>
                                <div>
                                    <input type="text" class="ays-enable-timer1" name="ays_pd_change_translation_name" id="ays_pd_change_translation_name" value="<?php echo $change_translation_name ?>">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="ays-pd-accordion-options-main-container" data-collapsed="false">
                    <div class="ays-pd-accordion-container">
                        <?php echo $pd_accordion_svg_html; ?>
                        <p class="ays-pd-subtitle"><?php echo __("Advanced settings" , $this->plugin_name)?></p>
                    </div>
                    <hr class="ays-pd-bolder-hr"/>
                    <div class="ays-pd-accordion-options-box">
                        <div class="form-group row">
                            <div class="col-sm-4">
                                <label for="ays_custom_class">
                                    <?php echo __('Custom class',$this->plugin_name); ?>
                                    <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Custom HTML class for dictionary container. You can use your class for adding your custom styles for dictionary container.',$this->plugin_name); ?>">
                                        <i class="ays_fa_pd ays_fa-info-circle"></i>
                                    </a>
                                </label>
                            </div>
                            <div class="col-sm-8 ays_divider_left">
                                <input type="text"  name="ays_custom_class" id="ays_custom_class" placeholder="myClass myAnotherClass..." value="<?php echo $custom_class; ?>">
                            </div>
                        </div>
                        <hr/>
                        <div class="form-group row">
                            <div class="col-sm-4">
                                <label for="ays_custom_css">
                                    <?php echo __('Custom CSS',$this->plugin_name)?>
                                    <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Enter your CSS code on the field.',$this->plugin_name)?>">
                                        <i class="ays_fa_pd ays_fa-info-circle"></i>
                                    </a>
                                </label>
                            </div>
                            <div class="col-sm-8 ays_divider_left">
                                <textarea class="ays-textarea" id="ays_custom_css" name="ays_pd_custom_css" cols="30"rows="10"><?php echo $custom_css ?></textarea>
                            </div>
                        </div> <!-- Custom CSS -->
                        <hr>
                    </div>
                </div>
                <div class="form-group row">
                    <div class="col-sm-4">
                        <label for="reset_to_default">
                            <?php echo __('Reset styles', $this->plugin_name) ?>
                            <a class="ays_help" data-toggle="tooltip"
                               title="<?php echo __('Reset tooltip styles to default values', $this->plugin_name) ?>">
                                <i class="ays_fa_pd ays_fa-info-circle"></i>
                            </a>
                        </label>
                    </div>
                    <div class="col-sm-8 ays_divider_left">
                        <button type="button" class="ays-button button-secondary"
                                id="reset_to_default"><?= __("Reset", $this->plugin_name) ?>
                        </button>
                    </div>
                </div>
            </div>
        </div>
        <?php
            $other_attributes = array();
            echo submit_button(__('Save', $this->plugin_name), 'primary ays-button-top ays-loader-banner', 'ays_pd_submit_top', false, $other_attributes);
        ?>
        <?php
            echo $loader_iamge;
        ?>
    </form>
</div>