(function(wp){
    var el = wp.element.createElement,
        registerBlockType = wp.blocks.registerBlockType,
        withSelect = wp.data.withSelect,
        BlockControls = wp.blockEditor.BlockControls,
        AlignmentToolbar = wp.blockEditor.AlignmentToolbar,
        InspectorControls = wp.blocks.InspectorControls,
        ServerSideRender = wp.serverSideRender,
        __ = wp.i18n.__,
        Text = wp.components.TextControl,
        aysSelect = wp.components.SelectControl,
        createBlock = wp.blocks.createBlock,
        select = wp.data.select,
        dispatch = wp.data.dispatch;

    var iconEl = el(
        'svg', 
        { 
            width: 24,
            height: 24,
            viewBox: '0 0 1200 1200',
            style: {
                transform: 'rotate(180deg)'
            }
        },
        el(
            'path',
            { 
                d: "M585 1184 c-149 -41 -223 -128 -233 -271 -2 -40 -7 -73 -11 -73 -3 0 -45 20 -93 45 -48 25 -90 45 -92 45 -2 0 12 -33 31 -74 35 -73 36 -73 87 -85 28 -6 101 -26 161 -44 97 -28 115 -37 154 -75 l43 -44 -23 42 c-13 23 -36 53 -51 66 -18 14 -26 28 -22 39 6 13 103 85 116 85 3 0 3 -11 0 -25 -10 -56 82 -10 124 61 29 50 22 50 99 -10 43 -35 55 -26 55 40 0 117 -83 234 -191 267 -82 25 -100 26 -154 11z M1070 896 c-30 -17 -71 -38 -90 -46 -110 -46 -223 -115 -265 -162 -56 -62 -59 -82 -6 -30 34 33 57 44 148 69 59 17 132 36 162 43 58 14 49 2 119 153 6 13 -12 6 -68 -27z M40 852 c0 -4 47 -149 105 -323 l106 -316 92 -6 c100 -6 169 -28 249 -78 l47 -30 42 31 c56 40 156 70 265 78 l87 7 102 310 c56 171 98 311 94 313 -4 2 -32 -13 -61 -32 -56 -38 -174 -80 -323 -115 -121 -28 -134 -39 -169 -144 -16 -48 -32 -87 -35 -87 -3 0 -17 35 -30 77 -36 113 -64 139 -171 159 -136 25 -263 70 -335 119 -36 24 -65 40 -65 37z",
                fill: '#0073AA'
            },
        )
    );

    registerBlockType( 'personal-dictionary/pd', {
        title: __('Personal Dictionary'),
        category: 'common',
        icon: iconEl,
    
        edit: ( function( props ) {
            wp.data.dispatch( 'core/block-editor' ).updateBlockAttributes( props.clientId, {
                shortcode: "[ayspd_userpage]",
            } );

            return el(ServerSideRender, {
                key: "editable",
                block: "personal-dictionary/pd",
                attributes: {shortcode: '[ayspd_userpage]' }
            });

        }),

        save: function(e) {
            return el("div", null, '[ayspd_userpage]');
        }
    } );

})(wp);
