<?php
    /**
     * Enqueue front end and editor JavaScript
     */

    function ays_pd_gutenberg_scripts() {
        global $current_screen;
        global $wp_version;
        $version1 = $wp_version;
        $operator = '>=';
        $version2 = '5.3.12';
        $versionCompare = personal_dictionary_versionCompare($version1, $operator, $version2);
        if( ! $current_screen ){
            return null;
        }

        if( ! $current_screen->is_block_editor ){
            return null;
        }

        wp_enqueue_script( PERSONAL_DICTIONARY_NAME . "-plugin", PERSONAL_DICTIONARY_PUBLIC_URL . '/js/personal-dictionary-public-plugin.js', array('jquery'), PERSONAL_DICTIONARY_VERSION, true);
        // $blockPath = 'personal-dictionary-block.js';
        
        // wp_enqueue_script( "jquery-effects-core");

        // Enqueue the bundled block JS file
        if($versionCompare){
            wp_enqueue_script(
                'personal-dictionary-block-js',
                PERSONAL_DICTIONARY_BASE_URL ."/personal-dictionary/personal-dictionary-block-new.js",
                array( 'jquery', 'wp-blocks', 'wp-i18n', 'wp-element', 'wp-components', 'wp-editor' ),
                PERSONAL_DICTIONARY_VERSION, true
            );
        } else {
            wp_enqueue_script(
                'personal-dictionary-block-js',
                PERSONAL_DICTIONARY_BASE_URL ."/personal-dictionary/personal-dictionary-block.js",
                array( 'jquery', 'wp-blocks', 'wp-i18n', 'wp-element', 'wp-components', 'wp-editor' ),
                PERSONAL_DICTIONARY_VERSION, true
            );
        }

        wp_enqueue_style( PERSONAL_DICTIONARY_NAME, PERSONAL_DICTIONARY_PUBLIC_URL . '/css/personal-dictionary-public.css', array(), PERSONAL_DICTIONARY_VERSION, 'all');
        
        // Enqueue the bundled block CSS file
        if($versionCompare) {
            wp_enqueue_style(
                'personal-dictionary-block-css',
                PERSONAL_DICTIONARY_BASE_URL ."/personal-dictionary/personal-dictionary-block-new.css",
                array(),
                PERSONAL_DICTIONARY_VERSION, 'all'
            );
        } else {
            wp_enqueue_style(
                'personal-dictionary-block-css',
                PERSONAL_DICTIONARY_BASE_URL ."/personal-dictionary/personal-dictionary-block.css",
                array(),
                PERSONAL_DICTIONARY_VERSION, 'all'
            );
        }
    }

    function ays_pd_gutenberg_block_register() {
        
        global $wpdb;
        $block_name = 'pd';
        $block_namespace = 'personal-dictionary/' . $block_name;
        
        register_block_type(
            $block_namespace, 
            array(
                'render_callback'   => 'personal_dictionary_render_callback',                
                'editor_script'     => 'personal-dictionary-block-js',
                'style'             => 'personal-dictionary-block-css',
                'attributes'	    => array(
                    'metaFieldValue' => array(
                        'type'  => 'integer', 
                    ),
                    'shortcode' => array(
                        'type'  => 'string',				
                    ),
                    'className' => array(
                        'type'  => 'string',
                    )
                ),
            )
        );
    }    

    function personal_dictionary_versionCompare($version1, $operator, $version2) {

        $_fv = intval ( trim ( str_replace ( '.', '', $version1 ) ) );
        $_sv = intval ( trim ( str_replace ( '.', '', $version2 ) ) );

        if (strlen ( $_fv ) > strlen ( $_sv )) {
            $_sv = str_pad ( $_sv, strlen ( $_fv ), 0 );
        }

        if (strlen ( $_fv ) < strlen ( $_sv )) {
            $_fv = str_pad ( $_fv, strlen ( $_sv ), 0 );
        }

        return version_compare ( ( string ) $_fv, ( string ) $_sv, $operator );
    }

    function personal_dictionary_render_callback( $attributes ) {
        $ays_html = "<div></div>";
        if(!empty($attributes["shortcode"])) {
            $ays_html = do_shortcode( $attributes["shortcode"] );
        }
        return $ays_html;
    }

    if(function_exists("register_block_type")){
        global $wp_version;

        // $version1 = $wp_version;
        // $operator = '>=';
        // $version2 = '5.2';
        // $versionCompare = personal_dictionary_versionCompare($version1, $operator, $version2);

        // if ( $versionCompare ) {
            // Hook scripts function into block editor hook
        add_action( 'enqueue_block_editor_assets', 'ays_pd_gutenberg_scripts' );
        add_action( 'init', 'ays_pd_gutenberg_block_register' );
        // }
    }
