(function( $ ) {
    var pdOptions = {};
    if( typeof window.aysPdOptions != 'undefined' ){
        var pdOptions = JSON.parse(atob(window.aysPdOptions));
    }

    if (pdOptions.pd_enable_add_words_from_front == 'on') {
        var dictionaryLogo = '<svg xmlns="http://www.w3.org/2000/svg" version="1.0" width="19px" height="19px" viewBox="0 0 19.000000 19.000000" preserveAspectRatio="xMidYMid meet"><g transform="translate(0.000000,19.000000) scale(0.100000,-0.100000)" fill="none" stroke="none"><path d="M70 160 c-19 -19 -27 -50 -14 -50 4 0 24 5 45 11 32 10 37 15 29 29 -15 28 -39 31 -60 10z" fill="#000"/><path d="M27 74 c15 -45 34 -55 91 -46 26 3 33 11 45 46 l15 43 -36 -13 c-20 -6 -38 -17 -40 -24 -4 -10 -6 -9 -12 0 -4 7 -24 18 -43 25 l-35 12 15 -43z" fill="#0073AA"/></g></svg>'

        $(document).mousedown(function (event) {
            var iconDiv = $(document).find('div.ays-pd-add-word-from-front-icon');
            var modalContent = $(document).find('div.ays-pd-add-word-modal-content');

            var ifIconClicked = false;
            if ($(event.target).hasClass('ays-pd-add-word-from-front-icon') || $(event.target).closest('.ays-pd-add-word-from-front-icon').length > 0) {
                ifIconClicked = true;
            }

            if (iconDiv.length != 0 ) {
                if (!ifIconClicked) {
                    iconDiv.remove()
                }
            }

            if (modalContent.length != 0) {
                var isModalClicked = false
                if ($(event.target).hasClass('ays-pd-add-word-modal-content') || $(event.target).closest('.ays-pd-add-word-modal-content').length > 0) {
                    isModalClicked = true;
                }

                if (!isModalClicked) {
                    modalContent.remove();
                }
            }

        });

        $(document).mouseup(function (event) {
            var iconDiv = $(document).find('div.ays-pd-add-word-from-front-icon');
            if ($(event.target).hasClass('ays-pd-add-word-from-front-icon') || $(event.target).closest('.ays-pd-add-word-from-front-icon').length > 0) {
                openPdModalWindow(iconDiv);
                return;
            }

            var selection = window.getSelection().toString().trim();
    
            if (selection !== '' && selection.length <= 250) {
                var div = $('<div>').attr( 'data-selected', selection ).addClass('ays-pd-add-word-from-front-icon').css({
                    width: '24px',
                    height: '24px',
                    display: 'flex',
                    justifyContent: 'center',
                    alignItems: 'center',
                    position: 'absolute',
                    background: '#fff',
                    borderRadius: '4px',
                    cursor: 'pointer',
                    border: '1px solid #ccc',
                    top: (event.pageY - 20) + 'px',
                    left: (event.pageX - 12) + 'px'
                });
                div.append(dictionaryLogo);
                $('body').append(div);
            }
        });

        function openPdModalWindow(iconDiv) {

            var selectedText = iconDiv.attr('data-selected');

            var modalContent = $('<div>').addClass('ays-pd-add-word-modal-content').css({
                position: 'absolute',
                top: iconDiv.offset().top + iconDiv.height() + 10 + 'px',
                left: iconDiv.offset().left + 'px',
                background: '#fff',
                border: '1px solid #ccc',
                padding: '10px',
                zIndex: '9999',
                maxWidth: '300px',
                borderRadius: '6px',
                boxShadow: '0px 5px 10px 2px rgba(34, 60, 80, 0.2)'
            });

            var wordInput = $('<input>').attr({
                type: 'text',
                value: selectedText
            }).css({
                width: '100%',
                boxSizing: 'border-box',
                marginBottom: '10px',
                padding: '15px 10px'
            });

            var translationInput = $('<input>').attr({
                type: 'text',
                placeholder: aysPersonalDictionaryFrontAjaxPublic.translation,
            }).css({
                width: '100%',
                boxSizing: 'border-box',
                marginBottom: '10px',
                padding: '15px 10px'
            });

            var groupSelect = $('<select>').css({
                width: '100%',
                boxSizing: 'border-box',
                marginBottom: '10px',
                padding: '15px 10px'
            });
            groupSelect.append($('<option>').attr('value', 0).text('Choose '+aysPersonalDictionaryFrontAjaxPublic.group+''));
            iconDiv.remove();

            var data = {};
            data.action = 'ays_pd_ajax';
            data.function = 'ays_groups_pd';

            $.ajax({
                url: aysPersonalDictionaryFrontAjaxPublic.ajaxUrl,
                dataType: 'json',
                method:'post',
                data: data,
                success: function(res) {
                    if(res.status === true){
                        var groups = res['results'];
                        for(let i = 0; i < groups.length; i++) {
                            groupSelect.append($('<option>').attr('value', groups[i].id).text(groups[i].name));
                        }
                    }
                }
            });

            var submitButton = $('<button>').text('Submit').attr({
                disabled: true,
            }).css({
                padding: '5px 10px',
                cursor: 'pointer',
                background: '#e5e5e5',
                border: '1px solid #747c85',
                color: '#747c85',
                borderRadius: '6px',
                translation: '0.3s'
            }).click(function() {
                var word = wordInput.val();
                var translation = translationInput.val();
                var selectedGroup = groupSelect.val();
                $('.ays-pd-add-word-modal-content').remove();
                addWordFromFront(word, translation, selectedGroup);
            });

            groupSelect.change(function() {
                if ($(this).val() != 0) {
                    submitButton.attr({
                        disabled: false
                    }).css({
                        border: '1px solid #1a7efb',
                        color: '#1a7efb',
                        background: '#fff'
                    })
                } else {
                    submitButton.attr({
                        disabled: true
                    }).css({
                        border: '1px solid #747c85',
                        color: '#747c85',
                        background: '#e5e5e5'
                    })
                }
            });

            modalContent.append(wordInput);
            modalContent.append(translationInput);
            modalContent.append(groupSelect);
            modalContent.append(submitButton);

            $('body').append(modalContent);
        }

        function addWordFromFront(word, translation, group) {
            var data = {};
			if(word != ''){
				data.action = 'ays_pd_ajax';
				data.word = word;
				data.translation = translation;
				data.category_id = group;
				data.function = 'ays_words_add_ajax';
				
				$.ajax({
					url: aysPersonalDictionaryFrontAjaxPublic.ajaxUrl,
					dataType: 'json',
					method:'post',
					data: data,
					success: function(res) {
                        var modalContent = $(document).find('div.ays-pd-add-word-modal-content');
                        modalContent.remove();
					},error: function(err){
						console.log(err);
					}
				});

			}
        }
    }

})( jQuery );
